/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.helper;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.helper.Mongo;
import tr.com.infumia.infumialib.helper.MongoDatabaseCredentials;

public final class HelperMongo
implements Mongo {
    @NotNull
    private final MongoClient client;
    @NotNull
    private final MongoDatabase database;
    @NotNull
    private final Datastore morphiaDatastore;

    public HelperMongo(@NotNull ClassLoader classLoader, @NotNull MongoDatabaseCredentials credentials, Class<?> ... classes) {
        String authParams = !credentials.username().isEmpty() && !credentials.password().isEmpty() ? credentials.username() + ":" + credentials.password() + "@" : "";
        String authSource = !credentials.authSource().isEmpty() ? "/?authSource=" + credentials.authSource() : "";
        String uri = !credentials.uri().isEmpty() ? credentials.uri() : "mongodb://" + authParams + credentials.host() + ":" + credentials.port() + authSource;
        this.client = MongoClients.create((String)uri);
        this.database = this.database(credentials.database());
        this.morphiaDatastore = this.morphiaDatastore(classLoader, credentials.database(), classes);
    }

    @NotNull
    private Datastore morphiaDatastore(@NotNull ClassLoader classLoader, @NotNull String name, Class<?> ... classes) {
        Datastore datastore = Morphia.createDatastore((MongoClient)this.client(), (String)name, (MapperOptions)MapperOptions.builder().classLoader(classLoader).build());
        for (Class<?> mapPackage : classes) {
            datastore.getMapper().map(new Class[]{mapPackage});
        }
        return datastore;
    }

    @Override
    @NotNull
    public MongoClient client() {
        return this.client;
    }

    @Override
    @NotNull
    public MongoDatabase database() {
        return this.database;
    }

    @Override
    @NotNull
    public Datastore morphiaDatastore() {
        return this.morphiaDatastore;
    }
}

