/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.definition;

import com.google.protobuf.GeneratedMessageV3;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.account.AccountStore;
import tr.com.infumia.infumialib.dynamism.DynamicStore;
import tr.com.infumia.infumialib.messaging.Travel;
import tr.com.infumia.infumialib.proto.Definitions;
import tr.com.infumia.infumialib.teleport.Teleport;

public interface Definition {

    public record Impl(@NotNull String id, @NotNull String name) implements OfflineUser
    {
    }

    public static interface Yaw {
        public float yaw();
    }

    public static interface WildcardClassType {
        @NotNull
        public Class<?> classType();
    }

    public static interface UniqueIdText {
        @NotNull
        default public UUID parsedUniqueId() {
            return UUID.fromString(this.uniqueId());
        }

        @NotNull
        public String uniqueId();
    }

    public static interface UniqueId {
        @NotNull
        public UUID uniqueId();

        @NotNull
        default public String uniqueIdAsString() {
            return this.uniqueId().toString();
        }
    }

    public static interface Type {
        @NotNull
        public String type();
    }

    public static interface TravelHolder {
        @NotNull
        public Travel travel();
    }

    public static interface Tps {
        public double tps();
    }

    public static interface ToProto<M extends GeneratedMessageV3> {
        @NotNull
        public M toProto();
    }

    public static interface ToJsonText {
        @NotNull
        public String toJsonAsText();
    }

    public static interface TeleportHolder {
        @NotNull
        public Teleport teleport();
    }

    public static interface StartTime {
        public long startTime();
    }

    public static interface ServerInfo
    extends ToProto<Definitions.ServerInfo>,
    Address,
    Port,
    Description,
    MsPerTick,
    PlayerCount,
    StartTime,
    Tps,
    ServerHolder {
        @NotNull
        public static ServerInfo of(@NotNull Server server, @NotNull String description, @NotNull String address, int port, int playerCount, long startTime, double tps, double msPerTick) {
            return new Impl(server, description, address, port, playerCount, startTime, tps, msPerTick);
        }

        @NotNull
        public static ServerInfo of(@NotNull Definitions.ServerInfo info) {
            return ServerInfo.of(Server.of(info.getServer()), info.getDescription(), info.getAddress(), info.getPort(), info.getPlayerCount(), info.getStartTime(), info.getTps(), info.getMsPerTick());
        }

        @Override
        @NotNull
        default public Definitions.ServerInfo toProto() {
            return Definitions.ServerInfo.newBuilder().setServer(this.server().toProto()).setDescription(this.description()).setAddress(this.address()).setPort(this.port()).setPlayerCount(this.playerCount()).setTps(this.tps()).setMsPerTick(this.msPerTick()).setStartTime(this.startTime()).build();
        }

        public record Impl(@NotNull Server server, @NotNull String description, @NotNull String address, int port, int playerCount, long startTime, double tps, double msPerTick) implements ServerInfo
        {
        }
    }

    public static interface ServerHolder {
        @NotNull
        public Server server();
    }

    public static interface Server
    extends ToProto<Definitions.Server>,
    Id,
    Name,
    Group {
        @NotNull
        public static Server of(@NotNull String id, @NotNull String name, @NotNull String group) {
            return new Impl(id, name, group);
        }

        @NotNull
        public static Server of(@NotNull Definitions.Server server) {
            return Server.of(server.getId(), server.getName(), server.getGroup());
        }

        @Override
        @NotNull
        default public Definitions.Server toProto() {
            return Definitions.Server.newBuilder().setId(this.id()).setName(this.name()).setGroup(this.group()).build();
        }

        public record Impl(@NotNull String id, @NotNull String name, @NotNull String group) implements Server
        {
        }
    }

    public static interface Serializer<R, F> {
        @NotNull
        default public Optional<F> deserialize(@NotNull R data) {
            return this.deserialize(data, null);
        }

        @NotNull
        public Optional<F> deserialize(@NotNull R var1, @Nullable F var2);

        @NotNull
        public Optional<R> serialize(@NotNull F var1);
    }

    public static interface PositionalZ {
        public double z();
    }

    public static interface PositionalY {
        public double y();
    }

    public static interface PositionalX {
        public double x();
    }

    public static interface PositionHolder {
        @NotNull
        public Position position();
    }

    public static interface Position
    extends ToProto<Definitions.Position>,
    EarthHolder,
    PositionalX,
    PositionalY,
    PositionalZ {
        @NotNull
        public static Position of(@NotNull Earth earth, double x, double y, double z) {
            return new Impl(earth, x, y, z);
        }

        @NotNull
        public static Position of(@NotNull Definitions.Position position) {
            return Position.of(Earth.of(position.getEarth()), position.getX(), position.getY(), position.getZ());
        }

        @Override
        @NotNull
        default public Definitions.Position toProto() {
            return Definitions.Position.newBuilder().setEarth(this.earth().toProto()).setX(this.x()).setY(this.y()).setZ(this.z()).build();
        }

        public record Impl(@NotNull Earth earth, double x, double y, double z) implements Position
        {
        }
    }

    public static interface Port {
        public int port();
    }

    public static interface PlayerCount {
        public int playerCount();
    }

    public static interface Pitch {
        public float pitch();
    }

    public static interface OfflineUserHolder {
        @NotNull
        public OfflineUser user();
    }

    public static interface OfflineUser
    extends ToProto<Definitions.OfflineUser>,
    Id,
    Name {
        @NotNull
        public static OfflineUser of(@NotNull String id, @NotNull String name) {
            return new Impl(id, name);
        }

        @NotNull
        public static OfflineUser of(@NotNull Definitions.OfflineUser user) {
            return OfflineUser.of(user.getId(), user.getName());
        }

        @Override
        @NotNull
        default public Definitions.OfflineUser toProto() {
            return Definitions.OfflineUser.newBuilder().setId(this.id()).setName(this.name()).build();
        }
    }

    public static interface NonPositionalNetworkUserHolder {
        @NotNull
        public NonPositionalNetworkUser user();
    }

    public static interface NonPositionalNetworkUser
    extends ToProto<Definitions.NonPositionalNetworkUser>,
    OfflineUserHolder,
    ServerHolder {
        @NotNull
        public static NonPositionalNetworkUser of(@NotNull OfflineUser user, @NotNull Server server) {
            return new Impl(user, server);
        }

        @NotNull
        public static NonPositionalNetworkUser of(@NotNull Definitions.NonPositionalNetworkUser user) {
            return NonPositionalNetworkUser.of(OfflineUser.of(user.getUser()), Server.of(user.getServer()));
        }

        @Override
        @NotNull
        default public Definitions.NonPositionalNetworkUser toProto() {
            return Definitions.NonPositionalNetworkUser.newBuilder().setUser(this.user().toProto()).setServer(this.server().toProto()).build();
        }

        public record Impl(@NotNull OfflineUser user, @NotNull Server server) implements NonPositionalNetworkUser
        {
        }
    }

    public static interface NetworkUserHolder {
        @NotNull
        public NetworkUser user();
    }

    public static interface NetworkUser
    extends ToProto<Definitions.NetworkUser>,
    OfflineUserHolder,
    NetworkPositionHolder {
        @NotNull
        public static NetworkUser of(@NotNull OfflineUser user, @NotNull NetworkPosition position) {
            return new Impl(user, position);
        }

        @NotNull
        public static NetworkUser of(@NotNull Definitions.NetworkUser user) {
            return NetworkUser.of(OfflineUser.of(user.getUser()), NetworkPosition.of(user.getPosition()));
        }

        @Override
        @NotNull
        default public Definitions.NetworkUser toProto() {
            return Definitions.NetworkUser.newBuilder().setUser(this.user().toProto()).setPosition(this.position().toProto()).build();
        }

        public record Impl(@NotNull OfflineUser user, @NotNull NetworkPosition position) implements NetworkUser
        {
        }
    }

    public static interface NetworkPositionHolder {
        @NotNull
        public NetworkPosition position();
    }

    public static interface NetworkPosition
    extends ToProto<Definitions.NetworkPosition>,
    ServerHolder,
    PositionHolder {
        @NotNull
        public static NetworkPosition of(@NotNull Server server, @NotNull Position position) {
            return new Impl(server, position);
        }

        @NotNull
        public static NetworkPosition of(@NotNull Definitions.NetworkPosition position) {
            return NetworkPosition.of(Server.of(position.getServer()), Position.of(position.getPosition()));
        }

        @Override
        @NotNull
        default public Definitions.NetworkPosition toProto() {
            return Definitions.NetworkPosition.newBuilder().setServer(this.server().toProto()).setPosition(this.position().toProto()).build();
        }

        public record Impl(@NotNull Server server, @NotNull Position position) implements NetworkPosition
        {
        }
    }

    public static interface Name {
        @NotNull
        public String name();
    }

    public static interface MsPerTick {
        public double msPerTick();
    }

    public static interface LongKey {
        public long key();
    }

    public static interface LoginChain
    extends Address,
    Name,
    UniqueIdText {
        @NotNull
        public static LoginChain of(@NotNull String address, @NotNull String name, @NotNull String uniqueId) {
            return new Impl(address, name, uniqueId);
        }

        @NotNull
        public static LoginChain of(@NotNull InetAddress address, @NotNull String name, @NotNull String uniqueId) {
            return LoginChain.of(address.getHostName(), name, uniqueId);
        }

        @NotNull
        public static LoginChain of(@NotNull InetAddress address, @NotNull String name, @NotNull UUID uniqueId) {
            return LoginChain.of(address, name, uniqueId.toString());
        }

        public record Impl(@NotNull String address, @NotNull String name, @NotNull String uniqueId) implements LoginChain
        {
        }
    }

    public static interface LastSeen {
        public boolean lastSeen();
    }

    public static interface Language {
        @NotNull
        public String language();
    }

    public static interface Key<K> {
        @NotNull
        public K key();
    }

    public static interface IntKey {
        public int key();
    }

    public static interface Id {
        @NotNull
        public String id();
    }

    public static interface Group {
        @NotNull
        public String group();
    }

    public static interface FirstSeen {
        public boolean firstSeen();
    }

    public static interface EarthHolder {
        @NotNull
        public Earth earth();
    }

    public static interface Earth
    extends ToProto<Definitions.Earth>,
    Id,
    Name {
        @NotNull
        public static Earth of(@NotNull String id, @NotNull String name) {
            return new Impl(id, name);
        }

        @NotNull
        public static Earth of(@NotNull Definitions.Earth earth) {
            return new Impl(earth.getId(), earth.getName());
        }

        @Override
        @NotNull
        default public Definitions.Earth toProto() {
            return Definitions.Earth.newBuilder().setId(this.id()).setName(this.name()).build();
        }

        public record Impl(@NotNull String id, @NotNull String name) implements Earth
        {
        }
    }

    public static interface DynamicStoreHolder {
        @NotNull
        public DynamicStore dynamicStore();
    }

    public static interface Description {
        @NotNull
        public String description();
    }

    public static interface ClassType<T> {
        @NotNull
        public Class<T> classType();
    }

    public static interface BytesSerializer<T>
    extends Serializer<byte[], T> {
    }

    public static interface Address {
        @NotNull
        public String address();
    }

    public static interface AccountStoreHolder {
        @NotNull
        public AccountStore accountStore();
    }
}

