/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.injector.loader;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tr.com.infumia.infumialib.slimjar.injector.loader.InjectableClassLoader;

public final class IsolatedInjectableClassLoader
extends InjectableClassLoader {
    private final Map<String, Class<?>> delegatesMap = new HashMap();

    public IsolatedInjectableClassLoader() {
        this(new URL[0]);
    }

    public IsolatedInjectableClassLoader(URL ... urls) {
        this(urls, Collections.emptySet());
    }

    public IsolatedInjectableClassLoader(URL[] urls, Collection<Class<?>> delegates) {
        this(urls, ClassLoader.getSystemClassLoader().getParent(), delegates);
    }

    public IsolatedInjectableClassLoader(URL[] urls, ClassLoader parent, Collection<Class<?>> delegates) {
        super(urls, parent);
        for (Class<?> clazz : delegates) {
            this.delegatesMap.put(clazz.getName(), clazz);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        Class<?> delegate = this.delegatesMap.get(name);
        if (delegate != null) {
            return delegate;
        }
        return super.loadClass(name, resolve);
    }
}

