/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.worldborderapi;

import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.BorderData;

public final class BorderDataTagType
implements PersistentDataType<PersistentDataContainer, BorderData> {
    @NotNull
    private final NamespacedKey damageAmountKey;
    @NotNull
    private final NamespacedKey damageBufferInBlocksKey;
    @NotNull
    private final NamespacedKey sizeKey;
    @NotNull
    private final NamespacedKey warningDistanceKey;
    @NotNull
    private final NamespacedKey warningTimeSecondsKey;
    @NotNull
    private final NamespacedKey xKey;
    @NotNull
    private final NamespacedKey zKey;

    public BorderDataTagType(@NotNull Plugin plugin) {
        this.sizeKey = new NamespacedKey(plugin, "size");
        this.xKey = new NamespacedKey(plugin, "center_x");
        this.zKey = new NamespacedKey(plugin, "center_z");
        this.damageBufferInBlocksKey = new NamespacedKey(plugin, "damage_buffer_in_blocks");
        this.warningTimeSecondsKey = new NamespacedKey(plugin, "warning_time_seconds");
        this.warningDistanceKey = new NamespacedKey(plugin, "warning_distance");
        this.damageAmountKey = new NamespacedKey(plugin, "damage_amount");
    }

    @NotNull
    private static <T, Z> Optional<Z> get(@NotNull PersistentDataContainer container, @NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        if (container.has(key, type)) {
            return Optional.ofNullable(container.get(key, type));
        }
        return Optional.empty();
    }

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<BorderData> getComplexType() {
        return BorderData.class;
    }

    @NotNull
    public PersistentDataContainer toPrimitive(@NotNull BorderData complex, @NotNull PersistentDataAdapterContext context) {
        PersistentDataContainer persistentDataContainer = context.newPersistentDataContainer();
        persistentDataContainer.set(this.sizeKey, PersistentDataType.DOUBLE, (Object)complex.size());
        complex.applyCenter((x, z) -> {
            persistentDataContainer.set(this.xKey, PersistentDataType.DOUBLE, x);
            persistentDataContainer.set(this.zKey, PersistentDataType.DOUBLE, z);
        });
        persistentDataContainer.set(this.damageBufferInBlocksKey, PersistentDataType.DOUBLE, (Object)complex.damageBufferInBlocks());
        persistentDataContainer.set(this.damageAmountKey, PersistentDataType.DOUBLE, (Object)complex.damageAmount());
        persistentDataContainer.set(this.warningTimeSecondsKey, PersistentDataType.INTEGER, (Object)complex.warningTimeSeconds());
        persistentDataContainer.set(this.warningDistanceKey, PersistentDataType.INTEGER, (Object)complex.warningDistance());
        return persistentDataContainer;
    }

    @NotNull
    public BorderData fromPrimitive(@NotNull PersistentDataContainer primitive, @NotNull PersistentDataAdapterContext context) {
        BorderData data = new BorderData();
        BorderDataTagType.get(primitive, this.sizeKey, PersistentDataType.DOUBLE).ifPresent(data::size);
        Optional centerX = BorderDataTagType.get(primitive, this.xKey, PersistentDataType.DOUBLE);
        Optional centerZ = BorderDataTagType.get(primitive, this.zKey, PersistentDataType.DOUBLE);
        if (centerX.isPresent() && centerZ.isPresent()) {
            data.center((Double)centerX.get(), (Double)centerZ.get());
        }
        BorderDataTagType.get(primitive, this.damageBufferInBlocksKey, PersistentDataType.DOUBLE).ifPresent(data::damageBufferInBlocks);
        BorderDataTagType.get(primitive, this.damageAmountKey, PersistentDataType.DOUBLE).ifPresent(data::damageAmount);
        BorderDataTagType.get(primitive, this.warningTimeSecondsKey, PersistentDataType.INTEGER).ifPresent(data::warningTimeSeconds);
        BorderDataTagType.get(primitive, this.warningDistanceKey, PersistentDataType.INTEGER).ifPresent(data::warningDistance);
        return data;
    }
}

