/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.configurate;

import java.lang.reflect.Type;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackUtil;

public final class ItemStackSerializer
implements TypeSerializer<ItemStack> {
    public static final ItemStackSerializer INSTANCE = new ItemStackSerializer();

    public ItemStack deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Optional<String> materialStringOptional = Optional.ofNullable(node.node(new Object[]{"material"}).getString());
        if (materialStringOptional.isEmpty()) {
            throw new SerializationException("Material key not found!");
        }
        String materialString = materialStringOptional.get();
        Optional<Material> materialOptional = ItemStackUtil.parseMaterial(materialString);
        if (materialOptional.isEmpty()) {
            throw new SerializationException("Material %s not found!".formatted(materialString));
        }
        ItemStackBuilder.Impl builder = ItemStackBuilder.simple(materialOptional.get());
        if (builder.isBanner()) {
            builder.asBanner().deserialize(node);
        } else if (builder.isBook()) {
            builder.asBook().deserialize(node);
        } else if (builder.isCrossbow()) {
            builder.asCrossbow().deserialize(node);
        } else if (builder.isFirework()) {
            builder.asFirework().deserialize(node);
        } else if (builder.isLeatherArmor()) {
            builder.asLeatherArmor().deserialize(node);
        } else if (builder.isMap()) {
            builder.asMap().deserialize(node);
        } else if (builder.isPotion()) {
            builder.asPotion().deserialize(node);
        } else if (builder.isSkull()) {
            builder.asSkull().deserialize(node);
        } else if (builder.isSpawnEgg()) {
            builder.asSpawnEgg().deserialize(node);
        } else {
            builder.deserialize(node);
        }
        return builder.itemStack();
    }

    public void serialize(Type type, @Nullable ItemStack obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.raw(null);
            return;
        }
        ItemStackBuilder.Impl builder = ItemStackBuilder.simple(obj);
        if (builder.isBanner()) {
            builder.asBanner().serialize(node);
        } else if (builder.isBook()) {
            builder.asBook().serialize(node);
        } else if (builder.isCrossbow()) {
            builder.asCrossbow().serialize(node);
        } else if (builder.isFirework()) {
            builder.asFirework().serialize(node);
        } else if (builder.isLeatherArmor()) {
            builder.asLeatherArmor().serialize(node);
        } else if (builder.isMap()) {
            builder.asMap().serialize(node);
        } else if (builder.isPotion()) {
            builder.asPotion().serialize(node);
        } else if (builder.isSkull()) {
            builder.asSkull().serialize(node);
        } else if (builder.isSpawnEgg()) {
            builder.asSpawnEgg().serialize(node);
        } else {
            builder.serialize(node);
        }
    }

    private ItemStackSerializer() {
    }
}

