/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.ObjectSerializer;
import tr.com.infumia.infumialib.transformer.TransformPack;
import tr.com.infumia.infumialib.transformer.Transformer;
import tr.com.infumia.infumialib.transformer.TwoSideTransformer;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericPair;
import tr.com.infumia.infumialib.transformer.transformers.TransformerObjectToString;

public final class TransformRegistry {
    @NotNull
    private final Set<ObjectSerializer<?>> serializers = new HashSet();
    @NotNull
    private final Map<GenericPair, Transformer<?, ?>> transformers = new ConcurrentHashMap();

    @NotNull
    public Optional<ObjectSerializer<?>> getSerializer(@NotNull Class<?> cls) {
        for (ObjectSerializer<?> serializer : this.serializers) {
            if (!serializer.supports(cls)) continue;
            return Optional.of(serializer);
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<Transformer<?, ?>> getTransformer(@Nullable GenericDeclaration from, @Nullable GenericDeclaration to) {
        return Optional.ofNullable(this.transformers.get(GenericPair.of(from, to)));
    }

    @NotNull
    public TransformRegistry withDefaultTransformers() {
        TransformPack.DEFAULT.accept(this);
        return this;
    }

    @NotNull
    public TransformRegistry withSerializers(ObjectSerializer<?> ... serializers) {
        return this.withSerializers(Set.of(serializers));
    }

    @NotNull
    public TransformRegistry withSerializers(@NotNull Collection<ObjectSerializer<?>> serializers) {
        this.serializers.addAll(serializers);
        return this;
    }

    @NotNull
    public TransformRegistry withTransformPacks(TransformPack ... packs) {
        for (TransformPack pack : packs) {
            pack.accept(this);
        }
        return this;
    }

    @NotNull
    public TransformRegistry withTransformer(@NotNull GenericPair pair, @NotNull Transformer<?, ?> transformer) {
        this.transformers.put(pair, transformer);
        return this;
    }

    @NotNull
    public TransformRegistry withTransformers(Transformer<?, ?> ... transformers) {
        return this.withTransformers(Set.of(transformers));
    }

    @NotNull
    public TransformRegistry withTransformers(@NotNull Collection<Transformer<?, ?>> transformers) {
        for (Transformer<?, ?> transformer : transformers) {
            if (transformer instanceof TwoSideTransformer) {
                this.withTwoSideTransformers((TwoSideTransformer)transformer);
                continue;
            }
            this.withTransformer(transformer.getPair(), transformer);
        }
        return this;
    }

    @NotNull
    public TransformRegistry withTransformersReversedToString(Transformer<?, ?> ... transformers) {
        return this.withTransformersReversedToString(Set.of(transformers));
    }

    @NotNull
    public TransformRegistry withTransformersReversedToString(@NotNull Collection<Transformer<?, ?>> transformers) {
        this.withTransformers(transformers);
        for (Transformer<?, ?> transformer : transformers) {
            this.withTransformer(transformer.getPair().reverse(), new TransformerObjectToString());
        }
        return this;
    }

    @NotNull
    public TransformRegistry withTwoSideTransformers(TwoSideTransformer<?, ?> ... transformers) {
        for (TwoSideTransformer<?, ?> transformer : transformers) {
            this.withTransformer(transformer.getPair(), transformer);
            this.withTransformer(transformer.reverse().getPair(), transformer.reverse());
        }
        return this;
    }

    @NotNull
    public TransformRegistry withTwoSideTransformers(@NotNull Collection<TwoSideTransformer<?, ?>> transformers) {
        for (TwoSideTransformer<?, ?> transformer : transformers) {
            this.withTransformer(transformer.getPair(), transformer);
        }
        for (TwoSideTransformer<?, ?> transformer : transformers) {
            TwoSideTransformer<?, ?> reverse = transformer.reverse();
            this.withTransformer(reverse.getPair(), reverse);
        }
        return this;
    }
}

