/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.platform.paper.hooks.Groups;

public final class LuckPermsWrapper
implements Wrapped {
    @NotNull
    private final LuckPerms luckPerms;

    public long getEffectiveLimitedPermission(@NotNull String permission, @NotNull Player player, long defaultValue) {
        return this.getEffectiveLimitedPermission(permission, player.getUniqueId(), defaultValue);
    }

    public long getEffectiveLimitedPermission(@NotNull String permission, @NotNull UUID uniqueId, long defaultValue) {
        AtomicLong calculatedLimit = new AtomicLong(defaultValue);
        User user = this.luckPerms.getUserManager().getUser(uniqueId);
        if (user == null) {
            return calculatedLimit.get();
        }
        Map permissionMap = user.getCachedData().getPermissionData().getPermissionMap();
        ArrayList<String> permissions = new ArrayList<String>();
        for (Map.Entry entry : permissionMap.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            permissions.add((String)entry.getKey());
        }
        if (permissions.isEmpty()) {
            return calculatedLimit.get();
        }
        Groups.calculatePermissionLimit(permission, permissions, calculatedLimit);
        return calculatedLimit.get();
    }

    @NotNull
    public Optional<String> getGroup(@NotNull String world, @NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(User::getPrimaryGroup);
    }

    @NotNull
    public Optional<List<String>> getGroupPrefix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> {
            ArrayList<String> list = new ArrayList<String>();
            for (PrefixNode node : nodes) {
                list.add(node.getMetaValue());
            }
            return list;
        });
    }

    @NotNull
    public Optional<List<String>> getGroupSuffix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.luckPerms.getGroupManager().getGroup(group)).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> {
            ArrayList<String> list = new ArrayList<String>();
            for (SuffixNode node : nodes) {
                list.add(node.getMetaValue());
            }
            return list;
        });
    }

    @NotNull
    public Optional<List<String>> getUserPrefix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.PREFIX))).map(nodes -> {
            ArrayList<String> list = new ArrayList<String>();
            for (PrefixNode node : nodes) {
                list.add(node.getMetaValue());
            }
            return list;
        });
    }

    @NotNull
    public Optional<List<String>> getUserSuffix(@NotNull Player player) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(player.getUniqueId())).map(gr -> new ArrayList(gr.getNodes(NodeType.SUFFIX))).map(nodes -> {
            ArrayList<String> list = new ArrayList<String>();
            for (SuffixNode node : nodes) {
                list.add(node.getMetaValue());
            }
            return list;
        });
    }

    public LuckPermsWrapper(@NotNull LuckPerms luckPerms) {
        if (luckPerms == null) {
            throw new NullPointerException("luckPerms is marked non-null but is null");
        }
        this.luckPerms = luckPerms;
    }
}

