/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.opener;

import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryOpener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Page;
import tr.com.infumia.infumialib.platform.paper.smartinventory.holder.SmartInventoryHolder;

public final class ChestInventoryOpener
implements InventoryOpener {
    @Override
    @NotNull
    public Inventory open(@NotNull InventoryContents contents) {
        Page page = contents.page();
        if (page.column() != 9) {
            throw new IllegalArgumentException(String.format("The column count for the chest inventory must be 9, found: %s.", page.column()));
        }
        if (page.row() < 1 && page.row() > 6) {
            throw new IllegalArgumentException(String.format("The row count for the chest inventory must be between 1 and 6, found: %s", page.row()));
        }
        SmartInventoryHolder holder = new SmartInventoryHolder(contents);
        holder.setActive(true);
        Inventory handle = Bukkit.createInventory((InventoryHolder)holder, (int)(page.row() * page.column()), (String)page.title());
        this.fill(handle, contents);
        contents.player().openInventory(handle);
        return handle;
    }

    @Override
    public boolean supports(@NotNull InventoryType type) {
        return type == InventoryType.CHEST || type == InventoryType.ENDER_CHEST;
    }
}

