/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.utils;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.utils.RunnableWrapper;

public final class TaskUtilities {
    @Nullable
    private static Plugin plugin;

    @NotNull
    public static BukkitTask async(@NotNull Runnable job) {
        return new RunnableWrapper(job).runTaskAsynchronously(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask async(@NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTaskAsynchronously(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask asyncLater(long delay, @NotNull Runnable job) {
        return new RunnableWrapper(job).runTaskLaterAsynchronously(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask asyncLater(long delay, @NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTaskLaterAsynchronously(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Consumer<BukkitRunnable> job) {
        return TaskUtilities.asyncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Predicate<BukkitRunnable> job) {
        return TaskUtilities.asyncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, @NotNull Predicate<BukkitRunnable> job) {
        return new RunnableWrapper(BukkitRunnable::cancel, job).runTaskTimerAsynchronously(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, @NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTaskTimerAsynchronously(TaskUtilities.getPlugin(), delay, period);
    }

    public static void init(@NotNull Plugin plugin) {
        TaskUtilities.plugin = plugin;
    }

    @NotNull
    public static <T> BukkitTask runForAll(@NotNull List<T> objects, @NotNull Consumer<T> job) {
        return TaskUtilities.runForAll(1, objects, job);
    }

    @NotNull
    public static <T> BukkitTask runForAll(int perTick, List<T> objects, @NotNull Consumer<T> job) {
        return TaskUtilities.runForAll(perTick, objects, job, runnable -> {});
    }

    @NotNull
    public static <T> BukkitTask runForAll(int perTick, @NotNull List<T> objects, @NotNull Consumer<T> job, @NotNull Consumer<BukkitRunnable> onDone) {
        AtomicInteger current = new AtomicInteger();
        return new RunnableWrapper(runnable -> {
            int bound = perTick;
            for (int i = 0; i < bound && current.get() < objects.size(); ++i) {
                Object object = objects.get(current.get());
                try {
                    job.accept(object);
                }
                catch (RuntimeException e) {
                    TaskUtilities.getPlugin().getLogger().log(Level.SEVERE, "TaskUtilities#forAll() iteration failed for object: " + object + (String)(object != null ? " (" + object.getClass().getName() + ")" : ""), e);
                }
                current.incrementAndGet();
            }
            if (current.get() >= objects.size()) {
                runnable.cancel();
                onDone.accept((BukkitRunnable)runnable);
            }
        }).runTaskTimer(TaskUtilities.getPlugin(), 1L, 1L);
    }

    @NotNull
    public static BukkitTask sync(@NotNull Runnable job) {
        return new RunnableWrapper(job).runTask(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask sync(@NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTask(TaskUtilities.getPlugin());
    }

    @NotNull
    public static BukkitTask syncLater(long delay, @NotNull Runnable job) {
        return new RunnableWrapper(job).runTaskLater(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask syncLater(long delay, @NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTaskLater(TaskUtilities.getPlugin(), delay);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Consumer<BukkitRunnable> job) {
        return TaskUtilities.syncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Predicate<BukkitRunnable> job) {
        return TaskUtilities.syncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, @NotNull Predicate<BukkitRunnable> job) {
        return new RunnableWrapper(BukkitRunnable::cancel, job).runTaskTimer(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, @NotNull Consumer<BukkitRunnable> job) {
        return new RunnableWrapper(job).runTaskTimer(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    private static Plugin getPlugin() {
        return Optional.ofNullable(plugin).orElseThrow(() -> new RuntimeException("Use TaskUtilities#init(Plugin) first!"));
    }

    private TaskUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

