/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.Pattern;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtFillRepeatingPatternStartIndex
implements PlaceType {
    private final int endIndex;
    @NotNull
    private final List<String> pattern;
    private final int startIndex;
    private final boolean wrapAround;

    public PtFillRepeatingPatternStartIndex(boolean wrapAround, @NotNull List<String> pattern, int startIndex, int endIndex) {
        this.wrapAround = wrapAround;
        this.pattern = Collections.unmodifiableList(pattern);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @NotNull
    private static PtFillRepeatingPatternStartIndex create(@NotNull Map<String, Object> objects) {
        return new PtFillRepeatingPatternStartIndex(PlaceType.getBoolean(objects, "wrap-around", false), PlaceType.getStringList(objects, "pattern", List.of("xxx", "yyy", "zzz")), PlaceType.getInteger(objects, "start-index", 0), PlaceType.getInteger(objects, "end-index", 1));
    }

    @Override
    @NotNull
    public String getType() {
        return "fill-repeating-pattern-start-index";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.fillPatternRepeating(new Pattern<Icon>(this.wrapAround, (String[])this.pattern.toArray(String[]::new)), this.startIndex, this.endIndex);
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("wrap-around", this.wrapAround, Boolean.TYPE);
        copy.addAsCollection("pattern", this.pattern, String.class);
        copy.add("start-index", this.startIndex, Integer.TYPE);
        copy.add("end-index", this.endIndex, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtFillRepeatingPatternStartIndex::create);
        }
    }
}

