/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.pl3x.map.api.Key;
import net.pl3x.map.api.MapWorld;
import net.pl3x.map.api.Pl3xMap;
import net.pl3x.map.api.SimpleLayerProvider;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap.Claim;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap.MapConfig;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap.MapTask;

public final class Pl3xMapWrapper
implements Wrapped {
    @NotNull
    private final Pl3xMap provider;
    private final Map<String, Map<UUID, MapTask>> tasks = new ConcurrentHashMap<String, Map<UUID, MapTask>>();

    public void create(@NotNull MapConfig config, @NotNull Predicate<String> worldsPredicate) {
        Plugin plugin = config.getPlugin();
        String name = plugin.getName();
        Map map = this.tasks.getOrDefault(name, new HashMap());
        for (MapWorld mapWorld : this.provider.mapWorlds()) {
            if (!worldsPredicate.test(mapWorld.name())) continue;
            SimpleLayerProvider provider = SimpleLayerProvider.builder((String)config.getControlLabel()).showControls(config.isControlShow()).defaultHidden(config.isControlHide()).build();
            Key key = Key.of((String)config.getWorldKeyPattern().replace("%world_unique_id%", mapWorld.uuid().toString()).replace("%world_name%", mapWorld.name()));
            mapWorld.layerRegistry().register(key, (Object)provider);
            MapTask task = new MapTask(config, key, provider, mapWorld);
            task.runTaskTimerAsynchronously(plugin, 0L, config.getUpdateInterval());
            map.put(mapWorld.uuid(), task);
        }
        this.tasks.put(name, map);
    }

    public void disable(@NotNull Plugin plugin) {
        this.disable(plugin.getName());
    }

    public void disable(@NotNull String pluginName) {
        Map<UUID, MapTask> map = this.tasks.get(pluginName);
        if (map != null) {
            map.values().forEach(MapTask::cancel);
            map.clear();
        }
    }

    public void newClaim(@NotNull Plugin plugin, @NotNull Claim claim) {
        this.newClaim(plugin.getName(), claim);
    }

    public void newClaim(@NotNull String pluginName, @NotNull Claim claim) {
        MapTask task;
        Map<UUID, MapTask> map = this.tasks.get(pluginName);
        if (map != null && (task = map.get(claim.getChunk().getWorld().getUID())) != null) {
            task.handleClaim(claim);
        }
    }

    public void removeClaim(@NotNull Plugin plugin, @NotNull Claim claim) {
        this.removeClaim(plugin.getName(), claim);
    }

    public void removeClaim(@NotNull String pluginName, @NotNull Claim claim) {
        MapTask task;
        Map<UUID, MapTask> map = this.tasks.get(pluginName);
        if (map != null && (task = map.get(claim.getChunk().getWorld().getUID())) != null) {
            task.removeMarker(claim);
        }
    }

    public Pl3xMapWrapper(@NotNull Pl3xMap provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.provider = provider;
    }
}

