/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.border;

import com.github.yannicklamprecht.worldborder.api.WorldBorderData;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldBorderDataTagType
implements PersistentDataType<PersistentDataContainer, WorldBorderData> {
    private final NamespacedKey damageAmountKey;
    private final NamespacedKey damageBufferInBlocksKey;
    private final NamespacedKey sizeKey;
    private final NamespacedKey warningDistanceKey;
    private final NamespacedKey warningTimeSecondsKey;
    private final NamespacedKey xKey;
    private final NamespacedKey zKey;

    public WorldBorderDataTagType(JavaPlugin javaPlugin) {
        this.sizeKey = new NamespacedKey((Plugin)javaPlugin, "size");
        this.xKey = new NamespacedKey((Plugin)javaPlugin, "center_x");
        this.zKey = new NamespacedKey((Plugin)javaPlugin, "center_z");
        this.damageBufferInBlocksKey = new NamespacedKey((Plugin)javaPlugin, "damage_buffer_in_blocks");
        this.damageAmountKey = new NamespacedKey((Plugin)javaPlugin, "damage_amount");
        this.warningTimeSecondsKey = new NamespacedKey((Plugin)javaPlugin, "warning_time_seconds");
        this.warningDistanceKey = new NamespacedKey((Plugin)javaPlugin, "warning_distance");
    }

    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    public Class<WorldBorderData> getComplexType() {
        return WorldBorderData.class;
    }

    public PersistentDataContainer toPrimitive(WorldBorderData complex, PersistentDataAdapterContext context) {
        PersistentDataContainer persistentDataContainer = context.newPersistentDataContainer();
        persistentDataContainer.set(this.sizeKey, PersistentDataType.DOUBLE, (Object)complex.getSize());
        complex.applyCenter((x, z) -> {
            persistentDataContainer.set(this.xKey, PersistentDataType.DOUBLE, x);
            persistentDataContainer.set(this.zKey, PersistentDataType.DOUBLE, z);
        });
        persistentDataContainer.set(this.damageBufferInBlocksKey, PersistentDataType.DOUBLE, (Object)complex.getDamageBuffer());
        persistentDataContainer.set(this.damageAmountKey, PersistentDataType.DOUBLE, (Object)complex.getDamageAmount());
        persistentDataContainer.set(this.warningTimeSecondsKey, PersistentDataType.INTEGER, (Object)complex.getWarningTimeSeconds());
        persistentDataContainer.set(this.warningDistanceKey, PersistentDataType.INTEGER, (Object)complex.getWarningDistance());
        return persistentDataContainer;
    }

    public WorldBorderData fromPrimitive(PersistentDataContainer primitive, PersistentDataAdapterContext context) {
        WorldBorderData worldBorderData = new WorldBorderData();
        this.get(primitive, this.sizeKey, PersistentDataType.DOUBLE).ifPresent(arg_0 -> ((WorldBorderData)worldBorderData).setSize(arg_0));
        Optional centerX = this.get(primitive, this.xKey, PersistentDataType.DOUBLE);
        Optional centerZ = this.get(primitive, this.zKey, PersistentDataType.DOUBLE);
        if (centerX.isPresent() && centerZ.isPresent()) {
            worldBorderData.setCenter(((Double)centerX.get()).doubleValue(), ((Double)centerZ.get()).doubleValue());
        }
        this.get(primitive, this.damageBufferInBlocksKey, PersistentDataType.DOUBLE).ifPresent(arg_0 -> ((WorldBorderData)worldBorderData).setDamageBuffer(arg_0));
        this.get(primitive, this.damageAmountKey, PersistentDataType.DOUBLE).ifPresent(arg_0 -> ((WorldBorderData)worldBorderData).setDamageAmount(arg_0));
        this.get(primitive, this.warningTimeSecondsKey, PersistentDataType.INTEGER).ifPresent(arg_0 -> ((WorldBorderData)worldBorderData).setWarningTimeSeconds(arg_0));
        this.get(primitive, this.warningDistanceKey, PersistentDataType.INTEGER).ifPresent(arg_0 -> ((WorldBorderData)worldBorderData).setWarningDistance(arg_0));
        return worldBorderData;
    }

    private <T, Z> Optional<Z> get(PersistentDataContainer persistentDataContainer, NamespacedKey namespacedKey, PersistentDataType<T, Z> type) {
        if (persistentDataContainer.has(namespacedKey, type)) {
            return Optional.ofNullable(persistentDataContainer.get(namespacedKey, type));
        }
        return Optional.empty();
    }
}

