/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.border;

import com.github.yannicklamprecht.worldborder.api.IWorldBorder;
import com.github.yannicklamprecht.worldborder.api.PersistentWorldBorderApi;
import com.github.yannicklamprecht.worldborder.api.Position;
import com.github.yannicklamprecht.worldborder.api.WorldBorderApi;
import com.github.yannicklamprecht.worldborder.api.WorldBorderData;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import tr.com.infumia.infumialib.platform.paper.border.WorldBorderDataTagType;

public final class PersistenceWrapper
implements PersistentWorldBorderApi {
    private final WorldBorderApi worldBorderApi;
    private final NamespacedKey worldBorderDataKey;
    private final WorldBorderDataTagType worldBorderDataTagType;

    public PersistenceWrapper(JavaPlugin javaPlugin, WorldBorderApi worldBorderApi) {
        this.worldBorderApi = worldBorderApi;
        this.worldBorderDataKey = new NamespacedKey((Plugin)javaPlugin, "world_border_data");
        this.worldBorderDataTagType = new WorldBorderDataTagType(javaPlugin);
    }

    public IWorldBorder getWorldBorder(Player p) {
        IWorldBorder worldBorder = this.worldBorderApi.getWorldBorder(p);
        PersistentDataContainer persistentDataContainer = p.getPersistentDataContainer();
        if (persistentDataContainer.has(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType)) {
            this.applyWorldDataToWorldBorder(worldBorder, (WorldBorderData)persistentDataContainer.get(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType));
        }
        return worldBorder;
    }

    public IWorldBorder getWorldBorder(World world) {
        return this.worldBorderApi.getWorldBorder(world);
    }

    public void resetWorldBorderToGlobal(Player player) {
        this.worldBorderApi.resetWorldBorderToGlobal(player);
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        if (persistentDataContainer.has(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType)) {
            persistentDataContainer.remove(this.worldBorderDataKey);
        }
    }

    public void setBorder(Player player, double size) {
        this.worldBorderApi.setBorder(player, size);
        this.modifyAndUpdateWorldData(player, worldBorderData -> worldBorderData.setSize(size));
    }

    public void setBorder(Player player, double size, Vector vector) {
        this.setBorder(player, size, Position.of((Vector)vector));
    }

    public void setBorder(Player player, double size, Location location) {
        this.setBorder(player, size, Position.of((Location)location));
    }

    public void setBorder(Player player, double size, Position position) {
        this.worldBorderApi.setBorder(player, size, position);
        this.modifyAndUpdateWorldData(player, worldBorderData -> {
            worldBorderData.setSize(size);
            worldBorderData.setCenter(position.x(), position.z());
        });
    }

    public void sendRedScreenForSeconds(Player player, long timeSeconds, JavaPlugin javaPlugin) {
        this.worldBorderApi.sendRedScreenForSeconds(player, timeSeconds, javaPlugin);
    }

    public void setBorder(Player player, double size, long milliSeconds) {
        this.worldBorderApi.setBorder(player, size, milliSeconds);
        this.modifyAndUpdateWorldData(player, worldBorderData -> worldBorderData.setSize(size));
    }

    public void setBorder(Player player, double size, long time, TimeUnit timeUnit) {
        this.worldBorderApi.setBorder(player, size, time, timeUnit);
        this.modifyAndUpdateWorldData(player, worldBorderData -> worldBorderData.setSize(size));
    }

    public WorldBorderData getWorldBorderData(Player p) {
        PersistentDataContainer persistentDataContainer = p.getPersistentDataContainer();
        if (persistentDataContainer.has(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType)) {
            return (WorldBorderData)persistentDataContainer.get(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType);
        }
        return null;
    }

    private void applyWorldDataToWorldBorder(IWorldBorder iWorldBorder, WorldBorderData worldBorderData) {
        worldBorderData.applyCenter((x, z) -> iWorldBorder.setCenter(new Position(x.doubleValue(), z.doubleValue())));
        iWorldBorder.setSize(worldBorderData.getSize());
        iWorldBorder.setDamageBufferInBlocks(worldBorderData.getDamageBuffer());
        iWorldBorder.setDamagePerSecondPerBlock(worldBorderData.getDamageAmount());
        iWorldBorder.setWarningDistanceInBlocks(worldBorderData.getWarningDistance());
        iWorldBorder.setWarningTimeInSeconds(worldBorderData.getWarningTimeSeconds());
    }

    private void modifyAndUpdateWorldData(Player player, Consumer<WorldBorderData> worldBorderDataConsumer) {
        PersistentDataContainer persistentDataContainer = player.getPersistentDataContainer();
        WorldBorderData worldBorderData = new WorldBorderData();
        if (persistentDataContainer.has(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType)) {
            worldBorderData = (WorldBorderData)persistentDataContainer.get(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType);
        }
        worldBorderDataConsumer.accept(worldBorderData);
        persistentDataContainer.set(this.worldBorderDataKey, (PersistentDataType)this.worldBorderDataTagType, (Object)worldBorderData);
    }
}

