/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.commands;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.paper.PaperCommandManager;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.InfumiaLib;
import tr.com.infumia.infumialib.platform.paper.commands.Command;
import tr.com.infumia.infumialib.platform.paper.utils.TaskUtilities;
import tr.com.infumia.infumialib.util.GitHubUpdateChecker;

public final class InfumiaPluginCommands
implements Command {
    @NotNull
    protected final PaperCommandManager<CommandSender> manager;
    @NotNull
    private final InfumiaLib plugin;

    @Override
    public void register() {
        Command.Builder builder = this.manager.commandBuilder("infumia", ArgumentDescription.of((String)"Main command of Infumia Library plugin."), new String[0]);
        Command.Builder mainCommand = builder.permission("infumiaplugin.command.main").handler(context -> ((CommandSender)context.getSender()).sendMessage(this.getVersionMessage()));
        Command.Builder reloadCommand = builder.literal("reload", ArgumentDescription.of((String)"Reloads Infumia Library plugin's configuration files."), new String[0]).permission("infumiaplugin.command.reload").handler(context -> TaskUtilities.async(() -> {
            this.plugin.loadFiles();
            ((CommandSender)context.getSender()).sendMessage(this.getReloadCompleteMessage());
        }));
        PluginDescriptionFile description = this.plugin.getDescription();
        Command.Builder updateCommand = builder.literal("update", ArgumentDescription.of((String)"Checks for update if Infumia Library plugin."), new String[0]).permission("infumiaplugin.command.update").handler(context -> GitHubUpdateChecker.checkForUpdate((Audience)context.getSender(), this.plugin.getSLF4JLogger(), description.getVersion(), description.getName(), "Infumia", "InfumiaLib"));
        this.manager.command(mainCommand).command(reloadCommand).command(updateCommand);
    }

    @NotNull
    private Component getReloadCompleteMessage() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"[InfumiaPlugin]").color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.space())).append(Component.text((String)"Reload complete!").color((TextColor)NamedTextColor.GREEN))).build();
    }

    @NotNull
    private Component getVersionMessage() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"Infumia Library Plugin made by").color((TextColor)NamedTextColor.YELLOW))).append((Component)Component.space())).append(((TextComponent)Component.text((String)"Infumia").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.UNDERLINED).clickEvent(ClickEvent.openUrl((String)"https://github.com/Infumia/")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Go to Infumia organization page.").color((TextColor)NamedTextColor.GRAY))))).append((Component)Component.newline())).append(((TextComponent)Component.text((String)"Current version").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.UNDERLINED).clickEvent(ClickEvent.openUrl((String)("https://github.com/Infumia/InfumiaPlugin/releases/tag/" + this.plugin.getDescription().getVersion()))))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Go to current version of Infumia Library.").color((TextColor)NamedTextColor.GRAY)))).append((Component)Component.space())).append(((TextComponent)Component.text((String)"Latest version").color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.UNDERLINED).clickEvent(ClickEvent.openUrl((String)"https://github.com/Infumia/InfumiaPlugin/releases/latest/")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Go to latest version of Infumia Library.").color((TextColor)NamedTextColor.GRAY))))).build();
    }

    public InfumiaPluginCommands(@NotNull PaperCommandManager<CommandSender> manager, @NotNull InfumiaLib plugin) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.manager = manager;
        this.plugin = plugin;
    }
}

