/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.util;

import org.jetbrains.annotations.NotNull;

public final class SlotPos {
    private final int column;
    private final int row;

    private SlotPos(int row, int column, boolean absolute) {
        if (absolute) {
            this.row = Math.abs(row);
            this.column = Math.abs(column);
        } else {
            this.row = row;
            this.column = column;
        }
    }

    @NotNull
    public static SlotPos of(int row, int column, boolean absolute) {
        return new SlotPos(row, column, absolute);
    }

    @NotNull
    public static SlotPos of(int index) {
        return SlotPos.of(index, false);
    }

    @NotNull
    public static SlotPos of(int index, boolean absolute) {
        return SlotPos.of(index / 9, index % 9, absolute);
    }

    @NotNull
    public static SlotPos of(int row, int column) {
        return SlotPos.of(row, column, false);
    }

    @NotNull
    public SlotPos addColumn(int column, boolean absolute) {
        return SlotPos.of(this.row, this.column + column, absolute);
    }

    @NotNull
    public SlotPos addColumn(int column) {
        return this.addColumn(column, false);
    }

    @NotNull
    public SlotPos addRow(int row, boolean absolute) {
        return SlotPos.of(this.row + row, this.column, absolute);
    }

    @NotNull
    public SlotPos addRow(int row) {
        return this.addRow(row, false);
    }

    @NotNull
    public SlotPos reverse(boolean absolute) {
        return SlotPos.of(this.column, this.row, absolute);
    }

    @NotNull
    public SlotPos reverse() {
        return this.reverse(false);
    }

    public int toIndex() {
        return this.row * 9 + this.column;
    }

    @NotNull
    public String toString() {
        return String.format("SlotPos{row=%d, column=%d}", this.row, this.column);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotPos)) {
            return false;
        }
        SlotPos other = (SlotPos)o;
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        return this.getRow() == other.getRow();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getColumn();
        result = result * 59 + this.getRow();
        return result;
    }
}

