/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.observer.Source;
import tr.com.infumia.infumialib.platform.paper.observer.source.BasicSource;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Handle;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryOpener;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryProvider;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Page;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartHolder;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartInventory;
import tr.com.infumia.infumialib.platform.paper.smartinventory.content.BasicInventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgCloseEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgInitEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.PgUpdateEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.CloseEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.PageEvent;

public final class BasicPage
implements Page {
    private final Collection<Handle<? extends PageEvent>> handles = new ArrayList<Handle<? extends PageEvent>>();
    @NotNull
    private final SmartInventory inventory;
    private final Source<InventoryContents> source = new BasicSource<InventoryContents>();
    @NotNull
    private final InventoryType type = InventoryType.CHEST;
    private boolean async = false;
    @NotNull
    private Predicate<CloseEvent> canClose = event -> true;
    private int column = 9;
    @NotNull
    private String id = "none";
    @Nullable
    private Page parent;
    @NotNull
    private InventoryProvider provider;
    private int row = 1;
    private long startDelay = 1L;
    private long tick = 1L;
    private boolean tickEnable = true;
    @NotNull
    private String title = "Smart Inventory";

    public BasicPage(@NotNull SmartInventory inventory) {
        this(inventory, InventoryProvider.EMPTY);
    }

    @Override
    public <T extends PageEvent> void accept(@NotNull T event) {
        for (Handle<? extends PageEvent> handle : this.handles) {
            if (!handle.type().isAssignableFrom(event.getClass())) continue;
            handle.accept(event);
        }
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    @NotNull
    public Page async(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public boolean canClose(@NotNull CloseEvent event) {
        return this.canClose.test(event);
    }

    @Override
    @NotNull
    public Page canClose(@NotNull Predicate<CloseEvent> predicate) {
        this.canClose = predicate;
        return this;
    }

    @Override
    public void close(@NotNull SmartHolder holder) {
        Player player = holder.getPlayer();
        InventoryContents contents = holder.getContents();
        PgCloseEvent event = new PgCloseEvent(contents, new InventoryCloseEvent(player.getOpenInventory()));
        if (!this.canClose(event)) {
            Bukkit.getScheduler().runTask(holder.getPlugin(), contents::reopen);
            return;
        }
        this.accept(event);
        this.inventory().stopTick(player.getUniqueId());
        this.source.unsubscribe(this.provider());
        holder.setActive(false);
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    @NotNull
    public Page column(int column) {
        this.column = column;
        return this;
    }

    @Override
    @NotNull
    public <T extends PageEvent> Page handle(@NotNull Handle<T> handle) {
        this.handles.add(handle);
        return this;
    }

    @Override
    @NotNull
    public Page id(@NotNull String id) {
        this.id = id;
        return this;
    }

    @Override
    @NotNull
    public String id() {
        return this.id;
    }

    @Override
    @NotNull
    public SmartInventory inventory() {
        return this.inventory;
    }

    @Override
    public void notifyUpdate(@NotNull InventoryContents contents) {
        this.accept(new PgUpdateEvent(contents));
        this.source.notifyTargets(contents);
    }

    @Override
    @NotNull
    public Inventory open(@NotNull Player player, int page, @NotNull Map<String, Object> properties, boolean close) {
        if (close) {
            SmartInventory.getHolder(player).ifPresent(holder -> holder.getPlayer().closeInventory());
        } else {
            SmartInventory.getHolder(player).ifPresent(holder -> {
                Page oldPage = holder.getPage();
                if (this.row != oldPage.row() || this.column != oldPage.column()) {
                    holder.getPlayer().closeInventory();
                }
            });
        }
        InventoryOpener opener = this.inventory().findOpener(this.type).orElseThrow(() -> new IllegalStateException("No opener found for the inventory type " + this.type.name()));
        this.source.subscribe(this.provider());
        BasicInventoryContents contents = new BasicInventoryContents(this, player);
        contents.pagination().page(page);
        properties.forEach(contents::setProperty);
        this.accept(new PgInitEvent(contents));
        this.provider().init(contents);
        Inventory opened = opener.open(contents);
        if (this.tickEnable()) {
            this.inventory().tick(player.getUniqueId(), this);
        }
        return opened;
    }

    @Override
    @NotNull
    public Optional<Page> parent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    @NotNull
    public Page parent(@NotNull Page parent) {
        this.parent = parent;
        return this;
    }

    @Override
    @NotNull
    public InventoryProvider provider() {
        return this.provider;
    }

    @Override
    @NotNull
    public Page provider(@NotNull InventoryProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public int row() {
        return this.row;
    }

    @Override
    @NotNull
    public Page row(int row) {
        this.row = row;
        return this;
    }

    @Override
    public long startDelay() {
        return this.startDelay;
    }

    @Override
    @NotNull
    public Page startDelay(long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    @Override
    public long tick() {
        return this.tick;
    }

    @Override
    @NotNull
    public Page tick(long tick) {
        this.tick = tick;
        return this;
    }

    @Override
    public boolean tickEnable() {
        return this.tickEnable;
    }

    @Override
    @NotNull
    public Page tickEnable(boolean tickEnable) {
        this.tickEnable = tickEnable;
        return this;
    }

    @Override
    @NotNull
    public String title() {
        return this.title;
    }

    @Override
    @NotNull
    public Page title(@NotNull String title) {
        this.title = title;
        return this;
    }

    public BasicPage(@NotNull SmartInventory inventory, @NotNull InventoryProvider provider) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.inventory = inventory;
        this.provider = provider;
    }
}

