/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.mongodb;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Entity(value="Location")
public final class LocationObject {
    @Id
    private int id;
    private float pitch;
    private String world;
    private double x;
    private double y;
    private float yaw;
    private double z;

    @NotNull
    public static LocationObject from(@NotNull Location location) {
        return new LocationObject(0, location.getPitch(), location.getWorld().getName(), location.getX(), location.getY(), location.getYaw(), location.getZ());
    }

    @NotNull
    public Location getLocation() {
        return new Location(Objects.requireNonNull(Bukkit.getWorld((String)this.world), "World not found!"), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public String toString() {
        return "LocationObject(id=" + this.id + ", pitch=" + this.pitch + ", world=" + this.world + ", x=" + this.x + ", y=" + this.y + ", yaw=" + this.yaw + ", z=" + this.z + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationObject)) {
            return false;
        }
        LocationObject other = (LocationObject)o;
        if (this.id != other.id) {
            return false;
        }
        if (Float.compare(this.pitch, other.pitch) != 0) {
            return false;
        }
        if (Double.compare(this.x, other.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, other.y) != 0) {
            return false;
        }
        if (Float.compare(this.yaw, other.yaw) != 0) {
            return false;
        }
        if (Double.compare(this.z, other.z) != 0) {
            return false;
        }
        String this$world = this.world;
        String other$world = other.world;
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.id;
        result = result * 59 + Float.floatToIntBits(this.pitch);
        long $x = Double.doubleToLongBits(this.x);
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.y);
        result = result * 59 + (int)($y >>> 32 ^ $y);
        result = result * 59 + Float.floatToIntBits(this.yaw);
        long $z = Double.doubleToLongBits(this.z);
        result = result * 59 + (int)($z >>> 32 ^ $z);
        String $world = this.world;
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public LocationObject() {
    }

    public LocationObject(int id, float pitch, String world, double x, double y, float yaw, double z) {
        this.id = id;
        this.pitch = pitch;
        this.world = world;
        this.x = x;
        this.y = y;
        this.yaw = yaw;
        this.z = z;
    }
}

