/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.messaging;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.messaging.Portal;
import tr.com.infumia.infumialib.messaging.Travel;
import tr.com.infumia.infumialib.messaging.proto.Definitions;
import tr.com.infumia.infumialib.teleport.Teleport;

public final class BukkitPlayerPortal
extends Portal.Base {
    private static final String TYPE = "player";

    public BukkitPlayerPortal(@NotNull Teleport teleport, @NotNull Travel travel, boolean requiredOnLogin) {
        super(requiredOnLogin, teleport, travel, TYPE);
    }

    @Override
    @NotNull
    public Optional<String> deserialize(byte @NotNull [] data, @Nullable String template) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        String uniqueId = in.readUTF();
        return Optional.of(uniqueId);
    }

    @Override
    @NotNull
    public Optional<byte[]> serialize(@NotNull String data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(data);
        return Optional.of(out.toByteArray());
    }

    @Override
    @NotNull
    public Portal.PositionResult onRequest(@NotNull Definitions.OfflineUser source, @NotNull String value) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(value));
        if (player == null) {
            return new Portal.PositionResult(Definitions.Error.newBuilder().setError("player-not-found").addArgs(source.getId()).addArgs(source.getName()).build(), null);
        }
        return new Portal.PositionResult(null, () -> {
            if (player.isOnline()) {
                return ImmutablePair.of(null, (Object)Definitions.Error.newBuilder().setError("player-not-online").addArgs(source.getId()).addArgs(source.getName()).build());
            }
            World world = player.getWorld();
            Location location = player.getLocation();
            Definitions.Position position = Definitions.Position.newBuilder().setEarth(Definitions.Earth.newBuilder().setId(world.getUID().toString()).setName(world.getName()).build()).setX(location.getX()).setY(location.getY() + 1.0).setZ(location.getZ()).setYaw(location.getYaw()).setPitch(location.getPitch()).build();
            return ImmutablePair.of((Object)position, (Object)this.teleport().canTeleport(source, TYPE, position));
        });
    }

    @Override
    @NotNull
    public Portal.BooleanResult sendRequest(@NotNull Definitions.OfflineUser source, @NotNull String value) {
        return null;
    }
}

