/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.Pattern;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtFillRepeatingPatternStart
implements PlaceType {
    private final int endColumn;
    private final int endRow;
    @NotNull
    private final List<String> pattern;
    private final int startColumn;
    private final int startRow;
    private final boolean wrapAround;

    public PtFillRepeatingPatternStart(boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, int endRow, int endColumn) {
        this.wrapAround = wrapAround;
        this.pattern = Collections.unmodifiableList(pattern);
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.endRow = endRow;
        this.endColumn = endColumn;
    }

    @NotNull
    private static PtFillRepeatingPatternStart create(@NotNull Map<String, Object> objects) {
        return new PtFillRepeatingPatternStart(PlaceType.getBoolean(objects, "wrap-around", false), PlaceType.getStringList(objects, "pattern", List.of("xxx", "yyy", "zzz")), PlaceType.getInteger(objects, "start-row", 0), PlaceType.getInteger(objects, "start-column", 0), PlaceType.getInteger(objects, "end-row", 0), PlaceType.getInteger(objects, "end-column", 1));
    }

    @Override
    @NotNull
    public String getType() {
        return "fill-repeating-pattern-start";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.fillPatternRepeating(new Pattern<Icon>(this.wrapAround, (String[])this.pattern.toArray(String[]::new)), this.startRow, this.startColumn, this.endRow, this.endColumn);
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("wrap-around", this.wrapAround, Boolean.TYPE);
        copy.addAsCollection("pattern", this.pattern, String.class);
        copy.add("start-row", this.startRow, Integer.TYPE);
        copy.add("start-column", this.startColumn, Integer.TYPE);
        copy.add("end-row", this.endRow, Integer.TYPE);
        copy.add("end-column", this.endColumn, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtFillRepeatingPatternStart::create);
        }
    }
}

