/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder.util;

import com.cryptomorin.xseries.XMaterial;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.BannerItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.BookItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Buildable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.CrossbowItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.FireworkItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.LeatherArmorItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.MapItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.PotionItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.SkullItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.SpawnEggItemBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class ItemStackUtil {
    private ItemStackUtil() {
    }

    @NotNull
    public static Optional<ItemStack> deserialize(@NotNull TransformedData data) {
        Optional<ItemStackBuilder> builderOptional = Builder.getSimpleItemStackDeserializer().apply(data);
        if (builderOptional.isEmpty()) {
            return Optional.empty();
        }
        ItemStackBuilder builder = builderOptional.get();
        if (builder.isFirework()) {
            return FireworkItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isLeatherArmor()) {
            return LeatherArmorItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isMap()) {
            return MapItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isPotion()) {
            return PotionItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isBanner()) {
            return BannerItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isBook()) {
            return BookItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isCrossbow()) {
            return CrossbowItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isSkull()) {
            return SkullItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        if (builder.isSpawnEgg()) {
            return SpawnEggItemBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
        }
        return ItemStackBuilder.getDeserializer().apply(data).map(Buildable::getItemStack);
    }

    @NotNull
    public static Optional<Material> parseMaterial(@NotNull String materialString) {
        if (Builder.VERSION <= 7) {
            return Optional.ofNullable(Material.getMaterial((String)materialString));
        }
        Optional xMaterial = XMaterial.matchXMaterial((String)materialString);
        if (xMaterial.isEmpty()) {
            return Optional.empty();
        }
        Optional<Material> material = Optional.ofNullable(((XMaterial)xMaterial.get()).parseMaterial());
        if (material.isEmpty()) {
            return Optional.empty();
        }
        return material;
    }

    public static void serialize(@NotNull ItemStack itemStack, @NotNull TransformedData data) {
        ItemStackUtil.serialize(ItemStackBuilder.from(itemStack), data);
    }

    public static void serialize(@NotNull Builder<?, ?> builder, @NotNull TransformedData data) {
        if (builder.isFirework()) {
            builder.asFirework().serialize(data);
        } else if (builder.isLeatherArmor()) {
            builder.asLeatherArmor().serialize(data);
        } else if (builder.isMap()) {
            builder.asMap().serialize(data);
        } else if (builder.isPotion()) {
            builder.asPotion().serialize(data);
        } else if (builder.isBanner()) {
            builder.asBanner().serialize(data);
        } else if (builder.isBook()) {
            builder.asBook().serialize(data);
        } else if (builder.isCrossbow()) {
            builder.asCrossbow().serialize(data);
        } else if (builder.isSkull()) {
            builder.asSkull().serialize(data);
        } else if (builder.isSpawnEgg()) {
            builder.asSpawnEgg().serialize(data);
        } else {
            builder.serialize(data);
        }
    }
}

