/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class SpawnEggItemBuilder
extends Builder<SpawnEggItemBuilder, SpawnEggMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    SpawnEggItemBuilder(@NotNull SpawnEggMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static SpawnEggItemBuilder from(@NotNull SpawnEggMeta itemMeta, @NotNull ItemStack itemStack) {
        return new SpawnEggItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static SpawnEggItemBuilder from(@NotNull TransformedData data) {
        return SpawnEggItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @NotNull
    public SpawnEggItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        String name = ((SpawnEggMeta)this.getItemMeta()).getSpawnedType().getName();
        if (name != null) {
            data.add("creature", name, String.class);
        }
    }

    @Deprecated
    @NotNull
    public SpawnEggItemBuilder setSpawnedType(@NotNull EntityType type) {
        ((SpawnEggMeta)this.getItemMeta()).setSpawnedType(type);
        return this.getSelf();
    }

    @Deprecated
    @NotNull
    public SpawnEggItemBuilder setSpawnedType(@NotNull String type) {
        EntityType entityType;
        try {
            entityType = EntityType.valueOf((String)type.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            entityType = EntityType.BAT;
        }
        return this.setSpawnedType(entityType);
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<SpawnEggItemBuilder>> {
        @Override
        @NotNull
        public Optional<SpawnEggItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            SpawnEggItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asSpawnEgg();
            data.get("creature", String.class).ifPresent(builder::setSpawnedType);
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

