/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.XItemStack;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class LeatherArmorItemBuilder
extends Builder<LeatherArmorItemBuilder, LeatherArmorMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    LeatherArmorItemBuilder(@NotNull LeatherArmorMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static LeatherArmorItemBuilder from(@NotNull LeatherArmorMeta itemMeta, @NotNull ItemStack itemStack) {
        return new LeatherArmorItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static LeatherArmorItemBuilder from(@NotNull TransformedData data) {
        return LeatherArmorItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @NotNull
    public LeatherArmorItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        Color color = ((LeatherArmorMeta)this.getItemMeta()).getColor();
        data.add("color", String.format("%d, %d, %d", color.getRed(), color.getGreen(), color.getBlue()), String.class);
    }

    @NotNull
    public LeatherArmorItemBuilder setColor(@Nullable Color color) {
        ((LeatherArmorMeta)this.getItemMeta()).setColor(color);
        return this.getSelf();
    }

    @NotNull
    public LeatherArmorItemBuilder setColor(@Nullable String color) {
        return this.setColor(XItemStack.parseColor((String)color));
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<LeatherArmorItemBuilder>> {
        @Override
        @NotNull
        public Optional<LeatherArmorItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            LeatherArmorItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asLeatherArmor();
            data.get("skull", String.class).ifPresent(builder::setColor);
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

