/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.util.ItemStackUtil;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class CrossbowItemBuilder
extends Builder<CrossbowItemBuilder, CrossbowMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    CrossbowItemBuilder(@NotNull CrossbowMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static CrossbowItemBuilder from(@NotNull CrossbowMeta itemMeta, @NotNull ItemStack itemStack) {
        return new CrossbowItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static CrossbowItemBuilder from(@NotNull TransformedData data) {
        return CrossbowItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @NotNull
    public CrossbowItemBuilder addChargedProjectile(ItemStack ... projectiles) {
        CrossbowMeta itemMeta = (CrossbowMeta)this.getItemMeta();
        for (ItemStack projectile : projectiles) {
            itemMeta.addChargedProjectile(projectile);
        }
        return this.getSelf();
    }

    @Override
    @NotNull
    public CrossbowItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        TransformedData projectiles = data.copy();
        List chargedProjectiles = ((CrossbowMeta)this.getItemMeta()).getChargedProjectiles();
        int bound = chargedProjectiles.size();
        for (int index = 0; index < bound; ++index) {
            ItemStack projectile = (ItemStack)chargedProjectiles.get(index);
            TransformedData section = data.copy();
            ItemStackUtil.serialize(projectile, section);
            projectiles.add(String.valueOf(index), section);
        }
        data.add("projectiles", projectiles);
    }

    @NotNull
    public CrossbowItemBuilder setChargedProjectiles(ItemStack ... projectiles) {
        return this.setChargedProjectiles(List.of(projectiles));
    }

    @NotNull
    public CrossbowItemBuilder setChargedProjectiles(@Nullable List<ItemStack> projectiles) {
        ((CrossbowMeta)this.getItemMeta()).setChargedProjectiles(projectiles);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<CrossbowItemBuilder>> {
        @Override
        @NotNull
        public Optional<CrossbowItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            CrossbowItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asCrossbow();
            ArrayList<ItemStack> projectiles = new ArrayList<ItemStack>();
            Optional<Map<String, ItemStack>> indexes = data.getAsMap("projectiles", String.class, ItemStack.class);
            indexes.ifPresent(index -> index.forEach((key, value) -> projectiles.add((ItemStack)value)));
            builder.setChargedProjectiles(projectiles);
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

