/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.BannerItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.BookItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.CrossbowItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.FireworkItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.LeatherArmorItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.MapItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.PotionItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.SkullItemBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.SpawnEggItemBuilder;
import tr.com.infumia.infumialib.platform.paper.color.XColor;
import tr.com.infumia.infumialib.transformer.TransformedData;

public interface Buildable<X extends Buildable<X, T>, T extends ItemMeta> {
    @NotNull
    default public BannerItemBuilder asBanner() {
        return new BannerItemBuilder(this.validateMeta(BannerMeta.class), this.getItemStack());
    }

    @NotNull
    default public BookItemBuilder asBook() {
        return new BookItemBuilder(this.validateMeta(BookMeta.class), this.getItemStack());
    }

    @NotNull
    default public CrossbowItemBuilder asCrossbow() {
        if (Builder.VERSION < 14) {
            throw new IllegalStateException("This method is for only 14 and newer versions!");
        }
        return new CrossbowItemBuilder(this.validateMeta(CrossbowMeta.class), this.getItemStack());
    }

    @NotNull
    default public FireworkItemBuilder asFirework() {
        return new FireworkItemBuilder(this.validateMeta(FireworkMeta.class), this.getItemStack());
    }

    @NotNull
    default public LeatherArmorItemBuilder asLeatherArmor() {
        return new LeatherArmorItemBuilder(this.validateMeta(LeatherArmorMeta.class), this.getItemStack());
    }

    @NotNull
    default public MapItemBuilder asMap() {
        return new MapItemBuilder(this.validateMeta(MapMeta.class), this.getItemStack());
    }

    @NotNull
    default public PotionItemBuilder asPotion() {
        return new PotionItemBuilder(this.validateMeta(PotionMeta.class), this.getItemStack());
    }

    @NotNull
    default public SkullItemBuilder asSkull() {
        return new SkullItemBuilder(this.validateMeta(SkullMeta.class), this.getItemStack());
    }

    @NotNull
    default public SpawnEggItemBuilder asSpawnEgg() {
        if (Builder.VERSION < 11) {
            throw new IllegalStateException("This method is for only 11 and newer versions!");
        }
        return new SpawnEggItemBuilder(this.validateMeta(SpawnEggMeta.class), this.getItemStack());
    }

    @NotNull
    public T getItemMeta();

    @NotNull
    default public ItemStack getItemStack() {
        return this.getItemStack(true);
    }

    @NotNull
    public X setItemStack(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getItemStack(boolean var1);

    @NotNull
    public X getSelf();

    default public boolean isBanner() {
        return this.isMeta(BannerMeta.class);
    }

    default public boolean isBook() {
        return this.isMeta(BookMeta.class);
    }

    default public boolean isCrossbow() {
        return Builder.VERSION >= 14 && this.isMeta(CrossbowMeta.class);
    }

    default public boolean isFirework() {
        return this.isMeta(FireworkMeta.class);
    }

    default public boolean isLeatherArmor() {
        return this.isMeta(LeatherArmorMeta.class);
    }

    default public boolean isMap() {
        return this.isMeta(MapMeta.class);
    }

    default public <I extends ItemMeta> boolean isMeta(@NotNull Class<I> meta) {
        return meta.isAssignableFrom(this.getItemMeta().getClass());
    }

    default public boolean isPotion() {
        return this.isMeta(PotionMeta.class);
    }

    default public boolean isSkull() {
        return this.isMeta(SkullMeta.class);
    }

    default public boolean isSpawnEgg() {
        return Builder.VERSION >= 11 && this.isMeta(SpawnEggMeta.class);
    }

    default public void serialize(@NotNull TransformedData data) {
        ItemStack itemStack = this.getItemStack();
        data.add("material", itemStack.getType().toString(), String.class);
        if (itemStack.getAmount() != 1) {
            data.add("amount", itemStack.getAmount(), Integer.TYPE);
        }
        if (itemStack.getDurability() != 0) {
            data.add("damage", itemStack.getDurability(), Short.TYPE);
        }
        if (Builder.VERSION < 13) {
            Optional.ofNullable(itemStack.getData()).filter(materialData -> materialData.getData() != 0).ifPresent(materialData -> data.add("data", materialData.getData(), Byte.TYPE));
        }
        Optional.ofNullable(itemStack.getItemMeta()).ifPresent(itemMeta -> {
            Set flags;
            ArrayList<String> list;
            block18: {
                MiniMessage miniMessage = MiniMessage.get();
                if (itemMeta.hasDisplayName()) {
                    if (XColor.isKyoriEnabled()) {
                        try {
                            Component component = itemMeta.displayName();
                            if (component != null) {
                                data.add("name", miniMessage.serialize(component), String.class);
                            }
                        }
                        catch (Exception e) {
                            data.add("name", XColor.deColorize(itemMeta.getDisplayName()), String.class);
                        }
                    } else {
                        data.add("name", XColor.deColorize(itemMeta.getDisplayName()), String.class);
                    }
                }
                if (itemMeta.hasLore()) {
                    if (XColor.isKyoriEnabled()) {
                        try {
                            List lore = itemMeta.lore();
                            if (lore != null) {
                                list = new ArrayList();
                                for (Component component : lore) {
                                    list.add((String)miniMessage.serialize(component));
                                }
                                data.addAsCollection("lore", list, String.class);
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            if (itemMeta.getLore() != null) {
                                data.addAsCollection("lore", XColor.deColorize(itemMeta.getLore()), String.class);
                            }
                            break block18;
                        }
                    }
                    if (itemMeta.getLore() != null) {
                        data.addAsCollection("lore", XColor.deColorize(itemMeta.getLore()), String.class);
                    }
                }
            }
            if (!(flags = itemMeta.getItemFlags()).isEmpty()) {
                list = new ArrayList<String>();
                for (ItemFlag flag : flags) {
                    list.add(flag.name());
                }
                data.addAsCollection("flags", list, String.class);
            }
            if (Builder.VERSION >= 14 && itemMeta.hasCustomModelData()) {
                data.add("custom-model-data", itemMeta.getCustomModelData());
            }
        });
        Map enchants = itemStack.getEnchantments();
        if (!enchants.isEmpty()) {
            HashMap enchantments = new HashMap();
            enchants.forEach((enchantment, integer) -> enchantments.put(enchantment.getName(), integer));
            data.addAsMap("enchants", enchantments, String.class, Integer.class);
        }
    }

    @NotNull
    default public <I extends ItemMeta> I validateMeta(@NotNull Class<I> meta) {
        if (!this.isMeta(meta)) {
            throw new IllegalArgumentException(String.format("%s's meta is not a %s!", this.getItemStack(), meta.getSimpleName()));
        }
        return (I)this.getItemMeta();
    }
}

