/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class BookItemBuilder
extends Builder<BookItemBuilder, BookMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    BookItemBuilder(@NotNull BookMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static BookItemBuilder from(@NotNull BookMeta itemMeta, @NotNull ItemStack itemStack) {
        return new BookItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static BookItemBuilder from(@NotNull TransformedData data) {
        return BookItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @NotNull
    public BookItemBuilder addPages(String ... list) {
        ((BookMeta)this.getItemMeta()).addPage(list);
        return this.getSelf();
    }

    @Override
    @NotNull
    public BookItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        BookMeta.Generation generation;
        super.serialize(data);
        HashMap<String, Object> book = new HashMap<String, Object>();
        BookMeta itemMeta = (BookMeta)this.getItemMeta();
        if (itemMeta.hasAuthor()) {
            book.put("title", itemMeta.getTitle());
        }
        if (itemMeta.hasAuthor()) {
            book.put("author", itemMeta.getAuthor());
        }
        if (Builder.VERSION >= 10 && (generation = itemMeta.getGeneration()) != null) {
            book.put("generation", generation.toString());
        }
        book.put("pages", itemMeta.getPages());
        data.addAsMap("book", book, String.class, Object.class);
    }

    @NotNull
    public BookItemBuilder setAuthor(@Nullable String author) {
        ((BookMeta)this.getItemMeta()).setAuthor(author);
        return this.getSelf();
    }

    @NotNull
    public BookItemBuilder setGeneration(@Nullable BookMeta.Generation generation) {
        if (Builder.VERSION >= 10) {
            ((BookMeta)this.getItemMeta()).setGeneration(generation);
        }
        return this.getSelf();
    }

    @NotNull
    public BookItemBuilder setPage(int page, @NotNull String text) {
        ((BookMeta)this.getItemMeta()).setPage(page, text);
        return this.getSelf();
    }

    @NotNull
    public BookItemBuilder setPages(String ... list) {
        return this.setPages(Arrays.asList(list));
    }

    @NotNull
    public BookItemBuilder setPages(@NotNull List<String> list) {
        ((BookMeta)this.getItemMeta()).setPages(list);
        return this.getSelf();
    }

    @NotNull
    public BookItemBuilder setTitle(@Nullable String title) {
        ((BookMeta)this.getItemMeta()).setTitle(title);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<BookItemBuilder>> {
        @Override
        @NotNull
        public Optional<BookItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            BookItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asBook();
            data.getAsMap("book", String.class, Object.class).ifPresent(book -> {
                TransformedData copy = data.copy((Map<String, Object>)book);
                String title = copy.get("title", String.class).orElse(null);
                String author = copy.get("author", String.class).orElse(null);
                List<String> pages = copy.getAsCollection("pages", String.class).orElse(Collections.emptyList());
                builder.setTitle(title);
                builder.setAuthor(author);
                builder.setPages(pages);
                if (Builder.VERSION >= 10) {
                    Optional.ofNullable(book.get("generation")).filter(String.class::isInstance).map(String.class::cast).ifPresent(generationString -> {
                        BookMeta.Generation generation;
                        try {
                            generation = BookMeta.Generation.valueOf((String)generationString);
                        }
                        catch (Exception e) {
                            generation = null;
                        }
                        builder.setGeneration(generation);
                    });
                }
            });
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

