/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.transformer.serializers;

import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.ObjectSerializer;
import tr.com.infumia.infumialib.transformer.TransformedData;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;

public final class Position {
    @NotNull
    private final String worldName;
    private final double x;
    private final double y;
    private final double z;
    private float pitch;
    private float yaw;

    public Position(@NotNull String worldName, int x, int y, int z) {
        this(worldName, (double)x, (double)y, (double)z);
    }

    public Position(@NotNull String worldName, int x, int y, int z, float yaw, float pitch) {
        this(worldName, (double)x, (double)y, (double)z, yaw, pitch);
    }

    @NotNull
    public Optional<Location> getLocation() {
        return Optional.ofNullable(Bukkit.getWorld((String)this.worldName)).map(world -> new Location(world, this.x, this.y, this.z, this.yaw, this.pitch));
    }

    @NotNull
    public Location getLocationThrown() {
        return new Location(Objects.requireNonNull(Bukkit.getWorld((String)this.worldName), "world"), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public Position(@NotNull String worldName, double x, double y, double z, float pitch, float yaw) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public Position(@NotNull String worldName, double x, double y, double z) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static final class Serializer
    implements ObjectSerializer<Position> {
        @Override
        @NotNull
        public Optional<Position> deserialize(@NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            return transformedData.get("world", String.class).map(world -> new Position((String)world, transformedData.get("x", Double.TYPE).orElse(0.0), transformedData.get("y", Double.TYPE).orElse(0.0), transformedData.get("z", Double.TYPE).orElse(0.0), transformedData.get("yaw", Float.TYPE).orElse(Float.valueOf(0.0f)).floatValue(), transformedData.get("pitch", Float.TYPE).orElse(Float.valueOf(0.0f)).floatValue()));
        }

        @Override
        @NotNull
        public Optional<Position> deserialize(@NotNull Position field, @NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            return this.deserialize(transformedData, declaration);
        }

        @Override
        public void serialize(@NotNull Position position, @NotNull TransformedData transformedData) {
            transformedData.add("world", position.getWorldName());
            transformedData.add("x", position.getX());
            transformedData.add("y", position.getY());
            transformedData.add("z", position.getZ());
            transformedData.add("yaw", Float.valueOf(position.getYaw()));
            transformedData.add("pitch", Float.valueOf(position.getPitch()));
        }

        @Override
        public boolean supports(@NotNull Class<?> cls) {
            return cls == Position.class;
        }
    }
}

