/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.scoreboard;

import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.scoreboard.line.LineColor;

public final class BukkitLineColor
implements LineColor {
    @NotNull
    private final ChatColor color;

    @NotNull
    public static LineColor create() {
        return new BukkitLineColor(ChatColor.RESET);
    }

    @Override
    @NotNull
    public String format(@NotNull String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    @Override
    @Nullable
    public LineColor getByChar(char charAt) {
        ChatColor newColor = ChatColor.getByChar((char)charAt);
        return newColor == null ? null : new BukkitLineColor(newColor);
    }

    @Override
    public char getColorChar() {
        return '\u00a7';
    }

    @Override
    @NotNull
    public String toString() {
        return this.color.toString();
    }

    private BukkitLineColor(@NotNull ChatColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.color = color;
    }
}

