/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.resolvers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.postprocessor.LineInfo;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;
import tr.com.infumia.infumialib.transformer.postprocessor.walkers.YamlSectionWalker;

public final class Snakeyaml
extends TransformResolver {
    @NotNull
    private final String commentPrefix;
    @NotNull
    private final Yaml config;
    @NotNull
    private final String sectionSeparator;
    @NotNull
    private Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    public Snakeyaml(@NotNull String commentPrefix, @NotNull String sectionSeparator) {
        this(commentPrefix, new Yaml((BaseConstructor)new Constructor(), Snakeyaml.apply(new Representer(), representer -> representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)), Snakeyaml.apply(new DumperOptions(), options -> options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)), new LoaderOptions(), new Resolver()), sectionSeparator);
    }

    public Snakeyaml(@NotNull String sectionSeparator) {
        this("# ", sectionSeparator);
    }

    public Snakeyaml() {
        this("");
    }

    @NotNull
    private static <T> T apply(@NotNull T object, @NotNull Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) throws Exception {
        this.map = (Map)this.config.load(inputStream);
        if (this.map == null) {
            this.map = new ConcurrentHashMap<String, Object>();
        }
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, final @NotNull TransformedObjectDeclaration declaration) {
        String contents = this.config.dump(this.map);
        PostProcessor processor = PostProcessor.of(contents).removeLines(line -> line.startsWith(this.commentPrefix.trim())).updateLinesPaths(new YamlSectionWalker(){

            @Override
            @NotNull
            public String update(@NotNull String line, @NotNull LineInfo lineInfo, @NotNull List<LineInfo> path) {
                TransformedObjectDeclaration currentDeclaration = declaration;
                for (int i = 0; i < path.size() - 1; ++i) {
                    LineInfo pathElement = path.get(i);
                    FieldDeclaration field = currentDeclaration.getNonMigratedFields().get(pathElement.getName());
                    if (field == null) {
                        return line;
                    }
                    GenericDeclaration fieldType = field.getGenericDeclaration();
                    Class<?> type = fieldType.getType();
                    if (type == null) continue;
                    if (!TransformedObject.class.isAssignableFrom(type)) {
                        return line;
                    }
                    currentDeclaration = TransformedObjectDeclaration.of(type);
                }
                FieldDeclaration lineDeclaration = currentDeclaration.getNonMigratedFields().get(lineInfo.getName());
                if (lineDeclaration == null) {
                    return line;
                }
                Comment fieldComment = lineDeclaration.getComment();
                if (fieldComment == null) {
                    return line;
                }
                return PostProcessor.addIndent(PostProcessor.createComment(Snakeyaml.this.commentPrefix, fieldComment.value()), lineInfo.getIndent()) + line;
            }
        });
        Comment header = declaration.getHeader();
        if (header != null) {
            processor.prependContextComment(this.commentPrefix, this.sectionSeparator, header.value());
        }
        processor.write(outputStream);
    }

    private Snakeyaml(@NotNull String commentPrefix, @NotNull Yaml config, @NotNull String sectionSeparator) {
        if (commentPrefix == null) {
            throw new NullPointerException("commentPrefix is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (sectionSeparator == null) {
            throw new NullPointerException("sectionSeparator is marked non-null but is null");
        }
        this.commentPrefix = commentPrefix;
        this.config = config;
        this.sectionSeparator = sectionSeparator;
    }
}

