/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.resolvers;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;

public class Hocon
extends TransformResolver {
    @NotNull
    private final String commentPrefix;
    private final ConfigRenderOptions renderOpts = ConfigRenderOptions.defaults().setFormatted(true).setOriginComments(false).setComments(true).setJson(false);
    @NotNull
    private final String sectionSeparator;
    @NotNull
    private Config config = ConfigFactory.parseMap(new LinkedHashMap());
    @NotNull
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Hocon(@NotNull String sectionSeparator) {
        this("# ", sectionSeparator);
    }

    public Hocon() {
        this("");
    }

    @NotNull
    private static Map<String, Object> hoconToMap(@NotNull Config config, @NotNull TransformedObjectDeclaration declaration) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (FieldDeclaration fieldDeclaration : declaration.getNonMigratedFields().values()) {
            String path = fieldDeclaration.getPath();
            if (!config.hasPath(path)) continue;
            result.put(path, config.getValue(path).unwrapped());
        }
        return result;
    }

    @NotNull
    private static Predicate<FieldDeclaration> isFieldDeclaredForLine(@NotNull String line) {
        return field -> {
            String path = field.getPath();
            return line.startsWith(path + "=") || line.startsWith(path + " =") || line.startsWith("\"" + path + "\"") || line.startsWith(path + "{") || line.startsWith(path + " {");
        };
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.config = ConfigFactory.parseString((String)PostProcessor.of(inputStream).getContext());
        this.map = Hocon.hoconToMap(this.config, declaration);
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    @Nullable
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        if (value == null) {
            return null;
        }
        GenericDeclaration genericsDeclaration = GenericDeclaration.of(value);
        if (genericsDeclaration.getType() == Character.TYPE || genericsDeclaration.getType() == Character.class) {
            return super.serialize(value, genericType, false);
        }
        return super.serialize(value, genericType, conservative);
    }

    @Override
    @NotNull
    public Map<?, ?> serializeMap(@NotNull Map<?, ?> value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        LinkedHashMap map = new LinkedHashMap();
        GenericDeclaration keyDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(0).orElse(null);
        GenericDeclaration valueDeclaration = genericType == null ? null : (GenericDeclaration)genericType.getSubTypeAt(1).orElse(null);
        value.forEach((key1, value1) -> map.put(this.serialize(key1, keyDeclaration, false), this.serialize(value1, valueDeclaration, conservative)));
        return map;
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.config = ConfigFactory.parseMap(this.map);
        StringBuilder builder = new StringBuilder();
        if (!declaration.getNonMigratedFields().isEmpty()) {
            for (FieldDeclaration field : declaration.getNonMigratedFields().values()) {
                Map<String, Optional<Object>> entryMap = Collections.singletonMap(field.getPath(), this.getValue(field.getPath()));
                Config entryConfig = ConfigFactory.parseMap(entryMap);
                builder.append(entryConfig.root().render(this.renderOpts)).append(this.sectionSeparator);
            }
        } else {
            builder.append(this.config.root().render(this.renderOpts));
        }
        PostProcessor processor = PostProcessor.of(builder.toString()).removeLines(line -> line.startsWith(this.commentPrefix.trim())).updateLines(line -> {
            Predicate<FieldDeclaration> predicate = Hocon.isFieldDeclaredForLine(line);
            for (FieldDeclaration fieldDeclaration : declaration.getNonMigratedFields().values()) {
                if (!predicate.test(fieldDeclaration)) continue;
                return Optional.of(fieldDeclaration).map(FieldDeclaration::getComment).map(comment -> this.sectionSeparator + PostProcessor.createComment(this.commentPrefix, comment.value()) + line).orElse((String)line);
            }
            return Optional.empty().map(FieldDeclaration::getComment).map(comment -> this.sectionSeparator + PostProcessor.createComment(this.commentPrefix, comment.value()) + line).orElse((String)line);
        });
        Comment header = declaration.getHeader();
        if (header != null) {
            processor.prependContextComment(this.commentPrefix, header.value());
        }
        processor.write(outputStream);
    }

    public Hocon(@NotNull String commentPrefix, @NotNull String sectionSeparator) {
        if (commentPrefix == null) {
            throw new NullPointerException("commentPrefix is marked non-null but is null");
        }
        if (sectionSeparator == null) {
            throw new NullPointerException("sectionSeparator is marked non-null but is null");
        }
        this.commentPrefix = commentPrefix;
        this.sectionSeparator = sectionSeparator;
    }
}

