/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.TransformPack;
import tr.com.infumia.infumialib.transformer.TransformRegistry;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.annotations.Migration;
import tr.com.infumia.infumialib.transformer.annotations.Variable;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;

public class TransformedObject {
    @Nullable
    private TransformedObjectDeclaration declaration;
    @Nullable
    private Path path;
    @Nullable
    private TransformResolver resolver;

    public TransformedObject(boolean noCache) {
    }

    public TransformedObject() {
        this.withDeclaration();
    }

    @NotNull
    public final Map<String, Object> asMap(@NotNull TransformResolver resolver, boolean conservative) throws TransformException {
        Objects.requireNonNull(this.declaration, "declaration");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.declaration.getNonMigratedFields().forEach((key, fieldDeclaration) -> map.put(fieldDeclaration.getPath(), resolver.serialize(fieldDeclaration.getValue(), fieldDeclaration.getGenericDeclaration(), conservative)));
        if (this.resolver == null) {
            return map;
        }
        for (String keyName : this.resolver.allKeys()) {
            if (map.containsKey(keyName)) continue;
            this.resolver.getValue(keyName).ifPresent(value -> map.put(keyName, this.resolver.serialize(value, GenericDeclaration.of(value), conservative)));
        }
        return map;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createDirectory(@NotNull Path path) throws IOException {
        Files.createDirectory(path, new FileAttribute[0]);
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createDirectory() throws IOException {
        return this.createDirectory(this.parent());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createDirectory(@NotNull File file) throws IOException {
        return this.createDirectory(file.toPath());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFile() throws IOException {
        return this.createFile(Objects.requireNonNull(this.path, "path"));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFile(@NotNull File file) throws IOException {
        return this.createFile(file.toPath());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFile(@NotNull Path path) throws IOException {
        Path parent = this.parent(path);
        if (!this.exists(parent)) {
            this.createDirectory(parent);
        }
        if (!this.exists(path)) {
            Files.createFile(path, new FileAttribute[0]);
        }
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFileUnchecked() {
        return this.createFileUnchecked(Objects.requireNonNull(this.path, "path"));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFileUnchecked(@NotNull File file) {
        return this.createFileUnchecked(file.toPath());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject createFileUnchecked(@NotNull Path path) {
        try {
            this.createFile(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Nullable
    public final TransformedObjectDeclaration declaration() {
        return this.declaration;
    }

    @NotNull
    public final TransformedObjectDeclaration declarationOrThrow() {
        return Objects.requireNonNull(this.declaration, "declaration");
    }

    public final boolean exists() {
        return this.exists(Objects.requireNonNull(this.path, "path"));
    }

    public final boolean exists(@NotNull File file) {
        return this.exists(file.toPath());
    }

    public final boolean exists(@NotNull Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    @NotNull
    public final Optional<Object> get(@NotNull String path) {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        FieldDeclaration field = this.declaration.getNonMigratedFields().get(path);
        if (field != null) {
            return Optional.ofNullable(field.getValue());
        }
        return this.resolver.getValue(path);
    }

    @NotNull
    public final <T> Optional<T> get(@NotNull String path, @NotNull Class<T> cls) {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        FieldDeclaration field = this.declaration.getNonMigratedFields().get(path);
        if (field == null) {
            return this.resolver.getValue(path, cls, null, null);
        }
        return Optional.ofNullable(this.resolver.deserialize(field.getValue(), field.getGenericDeclaration(), cls, GenericDeclaration.ofReady(cls), field.getStartingValue()));
    }

    @NotNull
    public final List<String> getAllKeys() {
        return new ArrayList<String>(this.declarationOrThrow().getNonMigratedFields().keySet());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate() throws TransformException {
        return this.initiate(true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate(boolean update) throws TransformException {
        return this.initiate(Objects.requireNonNull(this.path, "path"), update);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate(@NotNull File file) throws TransformException {
        return this.initiate(file, true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate(@NotNull File file, boolean update) throws TransformException {
        return this.initiate(file.toPath(), update);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate(@NotNull Path path) throws TransformException {
        return this.initiate(path, true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject initiate(@NotNull Path path, boolean update) throws TransformException {
        boolean notExist;
        boolean bl = notExist = !this.exists(path);
        if (notExist) {
            this.save(path);
        }
        return this.load(path, !notExist && update);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull File file) throws TransformException {
        return this.load(file, true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull File file, boolean update) throws TransformException {
        return this.load(file.toPath(), update);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull Map<String, Object> map) throws TransformException {
        Objects.requireNonNull(this.resolver, "resolver");
        map.forEach(this::set);
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull InputStream inputStream) {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        try {
            this.resolver.load(inputStream, this.declaration);
            return this.update();
        }
        catch (Exception exception) {
            throw new TransformException(String.format("Failed use #load(%s)", inputStream), exception);
        }
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull Path path) throws TransformException {
        return this.load(path, true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull Path path, boolean update) throws TransformException {
        try {
            this.load(new FileInputStream(path.toFile()));
            if (update) {
                this.save(path);
            }
        }
        catch (Exception exception) {
            throw new TransformException(String.format("Failed use #load(%s)", path), exception);
        }
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(@NotNull String data) {
        return this.load(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load() throws TransformException {
        return this.load(true);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject load(boolean update) throws TransformException {
        return this.load(Objects.requireNonNull(this.path, "path"), update);
    }

    @NotNull
    public final Path parent() {
        return this.parent(Objects.requireNonNull(this.path, "path"));
    }

    @NotNull
    public final Path parent(@NotNull Path path) {
        return path.toFile().getParentFile().toPath();
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject remove(@NotNull String path) {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        FieldDeclaration field = this.declaration.getNonMigratedFields().get(path);
        if (field != null) {
            field.setValue(null);
        }
        this.resolver.removeValue(path, field == null ? null : field.getGenericDeclaration(), field);
        return this;
    }

    @NotNull
    public final TransformResolver resolverOrThrow() {
        return Objects.requireNonNull(this.resolver, "resolver");
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject save(@NotNull OutputStream outputStream) throws TransformException {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        this.declaration.getNonMigratedFields().forEach((key, fieldDeclaration) -> {
            String path = fieldDeclaration.getPath();
            Object fieldValue = fieldDeclaration.getValue();
            if (!this.resolver.isValid((FieldDeclaration)fieldDeclaration, fieldValue)) {
                throw new TransformException(String.format("%s marked %s as invalid without throwing an exception", this.resolver.getClass(), path));
            }
            try {
                this.resolver.setValue(path, fieldValue, fieldDeclaration.getGenericDeclaration(), (FieldDeclaration)fieldDeclaration);
            }
            catch (Exception exception) {
                throw new TransformException(String.format("Failed to use #setValue(%s, %s, %s, %s)", path, fieldValue, fieldDeclaration.getGenericDeclaration(), fieldDeclaration), exception);
            }
        });
        try {
            this.resolver.write(outputStream, this.declaration);
        }
        catch (Exception exception) {
            throw new TransformException(String.format("Failed use #write(%s)", outputStream), exception);
        }
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject save() throws TransformException {
        return this.save(Objects.requireNonNull(this.path, "path"));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject save(@NotNull File file) throws TransformException {
        return this.save(file.toPath());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject save(@NotNull Path path) throws TransformException {
        try {
            this.createFileUnchecked(path);
            return this.save(new PrintStream((OutputStream)new FileOutputStream(path.toFile(), false), true, StandardCharsets.UTF_8.name()));
        }
        catch (Exception exception) {
            throw new TransformException(String.format("Failed use #save(%s)", path), exception);
        }
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject saveDefaults() throws TransformException {
        return this.saveDefaults(Objects.requireNonNull(this.path, "path"));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject saveDefaults(@NotNull File file) throws TransformException {
        if (this.exists(file)) {
            this.save(file);
        }
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject saveDefaults(@NotNull Path path) throws TransformException {
        return this.saveDefaults(path.toFile());
    }

    @NotNull
    public final String saveToString() throws TransformException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(outputStream);
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject set(@NotNull String path, @NotNull Object value) {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        FieldDeclaration field = this.declaration.getNonMigratedFields().get(path);
        Object tempValue = value;
        if (field != null) {
            GenericDeclaration genericDeclaration = field.getGenericDeclaration();
            if (genericDeclaration.getType() != null) {
                tempValue = this.resolver.deserialize(tempValue, GenericDeclaration.of(tempValue), genericDeclaration.getType(), genericDeclaration, null);
            }
            field.setValue(tempValue);
        }
        GenericDeclaration fieldGenerics = field == null ? null : field.getGenericDeclaration();
        this.resolver.setValue(path, tempValue, fieldGenerics, field);
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject update() {
        Objects.requireNonNull(this.resolver, "resolver");
        Objects.requireNonNull(this.declaration, "declaration");
        Optional.ofNullable(this.resolver.parentObject()).map(TransformedObject::declaration).map(TransformedObjectDeclaration::getVersion).ifPresent(this.declaration::setVersion);
        int fileVersion = this.resolver.allKeys().contains("file-version") ? this.get("file-version", Integer.TYPE).orElseThrow(() -> new TransformException("Something went wrong when getting the version.")) : 1;
        if (this.resolver.parentObject() == null) {
            this.set("file-version", this.declaration.getVersionInteger());
        }
        this.declaration.getAllFields().forEach((s, fieldDeclaration) -> {
            int version = this.declaration.getVersionInteger();
            Migration migration = fieldDeclaration.getMigration();
            if (migration == null || migration.value() <= 0 || IntStream.rangeClosed(fileVersion, version).noneMatch(value -> value == migration.value())) {
                return;
            }
            this.remove(fieldDeclaration.getPath());
        });
        this.declaration.getNonMigratedFields().forEach((key, fieldDeclaration) -> {
            Object value;
            String variableValue;
            String property;
            String fieldPath = fieldDeclaration.getPath();
            GenericDeclaration genericType = fieldDeclaration.getGenericDeclaration();
            Class<?> type = Objects.requireNonNull(genericType.getType(), "type");
            Variable variable = fieldDeclaration.getVariable();
            boolean updateValue = true;
            if (variable != null && (property = System.getProperty(variableValue = variable.value(), System.getenv(variableValue))) != null) {
                Object value2;
                try {
                    value2 = this.resolver.deserialize(property, GenericDeclaration.of(property), type, genericType, fieldDeclaration.getStartingValue());
                }
                catch (Exception exception) {
                    throw new TransformException(String.format("Failed to use #deserialize for @Variable { %s }", variableValue), exception);
                }
                if (!this.resolver.isValid((FieldDeclaration)fieldDeclaration, value2)) {
                    throw new TransformException(String.format("%s marked %s as invalid without throwing an exception", this.resolver.getClass(), fieldPath));
                }
                fieldDeclaration.setValue(value2);
                fieldDeclaration.setHideVariable(true);
                updateValue = false;
            }
            if (!this.resolver.pathExists(fieldPath)) {
                return;
            }
            try {
                value = this.resolver.getValue(fieldPath, type, genericType, fieldDeclaration.getStartingValue()).orElse(null);
            }
            catch (Exception exception) {
                throw new TransformException(String.format("Failed to use #getValue for %s", fieldPath), exception);
            }
            if (updateValue) {
                if (!this.resolver.isValid((FieldDeclaration)fieldDeclaration, value)) {
                    throw new TransformException(String.format("%s marked %s as invalid without throwing an exception", this.resolver.getClass(), fieldPath));
                }
                if (value != null) {
                    fieldDeclaration.setValue(value);
                }
            }
            fieldDeclaration.setStartingValue(value);
        });
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withDeclaration() {
        return this.withDeclaration(TransformedObjectDeclaration.of(this));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withDeclaration(@NotNull TransformedObjectDeclaration declaration) {
        this.declaration = declaration;
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withFile(@NotNull File file) {
        return this.withFile(file.toPath());
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withFile(@NotNull String path) {
        return this.withFile(Path.of(path, new String[0]));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withFile(@NotNull Path path) {
        this.path = path;
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withResolver(@NotNull TransformResolver resolver) {
        this.resolver = resolver.withCurrentObject(this);
        return this;
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withTransformPack(@NotNull @NotNull Consumer<@NotNull TransformRegistry> consumer) {
        return this.withTransformPack(TransformPack.create(consumer));
    }

    @NotNull
    @CanIgnoreReturnValue
    public final TransformedObject withTransformPack(@NotNull TransformPack pack) {
        this.resolverOrThrow().withTransformerPacks(pack);
        return this;
    }

    @Nullable
    public TransformResolver resolver() {
        return this.resolver;
    }
}

