/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class BukkitVersion {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("v?(?<major>[0-9]+)[._](?<minor>[0-9]+)(?:[._]R(?<micro>[0-9]+))?(?<sub>.*)");
    @NotNull
    private final String version;

    public BukkitVersion() {
        this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1));
    }

    public int getMajor() {
        return this.get("major");
    }

    public int getMicro() {
        return this.get("micro");
    }

    public int getMinor() {
        return this.get("minor");
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    private int get(@NotNull String key) {
        Matcher matcher = PATTERN.matcher(this.version);
        return matcher.matches() ? Integer.parseInt(matcher.group(key)) : 0;
    }

    public String toString() {
        return "BukkitVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitVersion)) {
            return false;
        }
        BukkitVersion other = (BukkitVersion)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public BukkitVersion(@NotNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }
}

