/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.transformer.resolvers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.transformer.resolvers.BukkitResolverHelper;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.transformer.postprocessor.LineInfo;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;
import tr.com.infumia.infumialib.transformer.postprocessor.walkers.YamlSectionWalker;

public final class BukkitSnakeyaml
extends TransformResolver {
    @NotNull
    private final String commentPrefix;
    @NotNull
    private final YamlConfiguration config;
    @NotNull
    private final String sectionSeparator;

    public BukkitSnakeyaml(@NotNull YamlConfiguration config, @NotNull String commentPrefix, @NotNull String sectionSeparator) {
        this(commentPrefix, config, sectionSeparator);
    }

    public BukkitSnakeyaml(@NotNull String commentPrefix, @NotNull String sectionSeparator) {
        this(commentPrefix, new YamlConfiguration(), sectionSeparator);
    }

    public BukkitSnakeyaml(@NotNull YamlConfiguration config) {
        this("# ", config, "");
    }

    public BukkitSnakeyaml(@NotNull String sectionSeparator) {
        this("# ", sectionSeparator);
    }

    public BukkitSnakeyaml() {
        this(new YamlConfiguration());
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.config.getKeys(false));
    }

    @Override
    @Nullable
    public <T> T deserialize(@Nullable Object object, @Nullable GenericDeclaration genericSource, @NotNull Class<T> targetClass, @Nullable GenericDeclaration genericTarget, @Nullable Object defaultValue) throws TransformException {
        if (object instanceof ConfigurationSection) {
            Map<String, Object> values = BukkitResolverHelper.getMapValues((ConfigurationSection)object, false);
            return super.deserialize(values, GenericDeclaration.of(values), targetClass, genericTarget, defaultValue);
        }
        return super.deserialize(object, genericSource, targetClass, genericTarget, defaultValue);
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.config.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) throws Exception {
        this.config.loadFromString(PostProcessor.of(inputStream).getContext());
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.config.getKeys(false).contains(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.config.set(path, null);
    }

    @Override
    @Nullable
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        if (value instanceof ConfigurationSection) {
            return BukkitResolverHelper.getMapValues((ConfigurationSection)value, false);
        }
        return super.serialize(value, genericType, conservative);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.config.set(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, final @NotNull TransformedObjectDeclaration declaration) {
        String contents = this.config.saveToString();
        PostProcessor processor = PostProcessor.of(contents).removeLines(line -> line.startsWith(this.commentPrefix.trim())).updateLinesPaths(new YamlSectionWalker(){

            @Override
            @NotNull
            public String update(@NotNull String line, @NotNull LineInfo lineInfo, @NotNull List<LineInfo> path) {
                TransformedObjectDeclaration currentDeclaration = declaration;
                for (int i = 0; i < path.size() - 1; ++i) {
                    LineInfo pathElement = path.get(i);
                    FieldDeclaration field = currentDeclaration.getNonMigratedFields().get(pathElement.getName());
                    if (field == null) {
                        return line;
                    }
                    GenericDeclaration fieldType = field.getGenericDeclaration();
                    Class<?> type = fieldType.getType();
                    if (type == null) continue;
                    if (!TransformedObject.class.isAssignableFrom(type)) {
                        return line;
                    }
                    currentDeclaration = TransformedObjectDeclaration.of(type);
                }
                FieldDeclaration lineDeclaration = currentDeclaration.getNonMigratedFields().get(lineInfo.getName());
                if (lineDeclaration == null) {
                    return line;
                }
                Comment fieldComment = lineDeclaration.getComment();
                if (fieldComment == null) {
                    return line;
                }
                return PostProcessor.addIndent(PostProcessor.createComment(BukkitSnakeyaml.this.commentPrefix, fieldComment.value()), lineInfo.getIndent()) + line;
            }
        });
        Comment header = declaration.getHeader();
        if (header != null) {
            processor.prependContextComment(this.commentPrefix, this.sectionSeparator, header.value());
        }
        processor.write(outputStream);
    }

    private BukkitSnakeyaml(@NotNull String commentPrefix, @NotNull YamlConfiguration config, @NotNull String sectionSeparator) {
        if (commentPrefix == null) {
            throw new NullPointerException("commentPrefix is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (sectionSeparator == null) {
            throw new NullPointerException("sectionSeparator is marked non-null but is null");
        }
        this.commentPrefix = commentPrefix;
        this.config = config;
        this.sectionSeparator = sectionSeparator;
    }
}

