/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.scoreboard;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.scoreboard.BukkitPlayerScoreboard;
import tr.com.infumia.infumialib.scoreboard.Board;
import tr.com.infumia.infumialib.scoreboard.ScoreboardSender;
import tr.com.infumia.infumialib.scoreboard.line.Line;

public final class BukkitScoreboardSender
implements ScoreboardSender<Player> {
    @NotNull
    private final Plugin plugin;
    private final Map<UUID, BukkitPlayerScoreboard> scoreboards = new ConcurrentHashMap<UUID, BukkitPlayerScoreboard>();

    @Override
    public void close() {
        this.scoreboards.values().forEach(BukkitPlayerScoreboard::close);
        this.scoreboards.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NotNull Board<Player> board, @NotNull Collection<Player> observers, @NotNull List<Line<Player>> lines) {
        Map<UUID, BukkitPlayerScoreboard> map = this.scoreboards;
        synchronized (map) {
            for (Player observer : observers) {
                this.scoreboards.computeIfAbsent(observer.getUniqueId(), uuid -> BukkitPlayerScoreboard.create(board, lines, this.plugin, uuid)).update(lines);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<BukkitPlayerScoreboard> getScoreboards() {
        Map<UUID, BukkitPlayerScoreboard> map = this.scoreboards;
        synchronized (map) {
            return this.scoreboards.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQuit(@NotNull Player player) {
        Map<UUID, BukkitPlayerScoreboard> map = this.scoreboards;
        synchronized (map) {
            Optional.ofNullable(this.scoreboards.remove(player.getUniqueId())).ifPresent(scoreboard -> BukkitPlayerScoreboard.close(player));
        }
    }

    BukkitScoreboardSender(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

