/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.mongodb;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.location.Cuboid;

@Entity(value="Cuboid")
public final class CuboidObject {
    @Id
    private int id;
    private double maxX;
    private double maxY;
    private double maxZ;
    private double minX;
    private double minY;
    private double minZ;
    private String world;

    @NotNull
    public static CuboidObject from(@NotNull Cuboid cuboid) {
        return new CuboidObject(0, cuboid.getMaxX(), cuboid.getMaxY(), cuboid.getMaxZ(), cuboid.getMinX(), cuboid.getMinY(), cuboid.getMinZ(), cuboid.getWorldName());
    }

    @NotNull
    public Cuboid getCuboid() {
        return new Cuboid(this.getMinimumLocation(), this.getMaximumLocation());
    }

    @NotNull
    public Cuboid getCuboid(boolean block) {
        return new Cuboid(this.getMinimumLocation(), this.getMaximumLocation(), block);
    }

    @NotNull
    private World getBukkitWorld() {
        return Objects.requireNonNull(Bukkit.getWorld((String)this.world), "World not found!");
    }

    @NotNull
    private Location getMaximumLocation() {
        return new Location(this.getBukkitWorld(), this.maxX, this.maxY, this.maxZ);
    }

    @NotNull
    private Location getMinimumLocation() {
        return new Location(this.getBukkitWorld(), this.minX, this.minY, this.minZ);
    }

    public String toString() {
        return "CuboidObject(id=" + this.id + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + ", minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", world=" + this.world + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CuboidObject)) {
            return false;
        }
        CuboidObject other = (CuboidObject)o;
        if (this.id != other.id) {
            return false;
        }
        if (Double.compare(this.maxX, other.maxX) != 0) {
            return false;
        }
        if (Double.compare(this.maxY, other.maxY) != 0) {
            return false;
        }
        if (Double.compare(this.maxZ, other.maxZ) != 0) {
            return false;
        }
        if (Double.compare(this.minX, other.minX) != 0) {
            return false;
        }
        if (Double.compare(this.minY, other.minY) != 0) {
            return false;
        }
        if (Double.compare(this.minZ, other.minZ) != 0) {
            return false;
        }
        String this$world = this.world;
        String other$world = other.world;
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.id;
        long $maxX = Double.doubleToLongBits(this.maxX);
        result = result * 59 + (int)($maxX >>> 32 ^ $maxX);
        long $maxY = Double.doubleToLongBits(this.maxY);
        result = result * 59 + (int)($maxY >>> 32 ^ $maxY);
        long $maxZ = Double.doubleToLongBits(this.maxZ);
        result = result * 59 + (int)($maxZ >>> 32 ^ $maxZ);
        long $minX = Double.doubleToLongBits(this.minX);
        result = result * 59 + (int)($minX >>> 32 ^ $minX);
        long $minY = Double.doubleToLongBits(this.minY);
        result = result * 59 + (int)($minY >>> 32 ^ $minY);
        long $minZ = Double.doubleToLongBits(this.minZ);
        result = result * 59 + (int)($minZ >>> 32 ^ $minZ);
        String $world = this.world;
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public CuboidObject() {
    }

    public CuboidObject(int id, double maxX, double maxY, double maxZ, double minX, double minY, double minZ, String world) {
        this.id = id;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.world = world;
    }
}

