/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.messaging;

import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.shared.proto.Definitions;
import tr.com.infumia.infumialib.teleport.Teleport;

public record BukkitTeleport(@NotNull Plugin plugin) implements Teleport
{
    @Override
    public void nativeTeleport(@NotNull Definitions.OfflineUser source, @NotNull String reason, @NotNull Definitions.Position position, @NotNull Consumer< @Nullable Definitions.Error> consumer) {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(source.getId()));
        if (player == null) {
            consumer.accept(Definitions.Error.newBuilder().setError("player-not-found").addArgs(source.getId()).addArgs(source.getName()).build());
            return;
        }
        Definitions.Earth earth = position.getEarth();
        World world = Bukkit.getWorld((UUID)UUID.fromString(earth.getId()));
        if (world == null) {
            consumer.accept(Definitions.Error.newBuilder().setError("world-not-found").addArgs(earth.getId()).addArgs(earth.getName()).build());
            return;
        }
        Location location = new Location(world, position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
        Bukkit.getScheduler().runTask(this.plugin, () -> player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN).thenAccept(done -> {
            if (done.booleanValue()) {
                consumer.accept(null);
            } else {
                consumer.accept(Definitions.Error.newBuilder().setError("could-not-teleport").build());
            }
        }));
    }
}

