/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.AddonClassLoader;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public final class BentoBoxWrapper
implements Wrapped {
    private static final Map<Plugin, Boolean> CACHE = new HashMap<Plugin, Boolean>();
    @NotNull
    private final BentoBox bentoBox;
    @NotNull
    private final AddonClassLoader classLoader;

    public static boolean isCache(@NotNull Plugin plugin) {
        return CACHE.getOrDefault(plugin, false);
    }

    public static void setCache(@NotNull Plugin plugin, boolean cache) {
        CACHE.put(plugin, cache);
    }

    public void addIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        this.setIslandLevel(plugin, uuid, this.getIslandLevel(uuid) + level);
    }

    @NotNull
    public Optional<Island> findFirstIsland(@NotNull UUID uuid) {
        for (Island island : this.bentoBox.getIslands().getIslands()) {
            if (island.getWorld() == null || island.getOwner() == null || !island.getOwner().equals(uuid)) continue;
            return Optional.of(island);
        }
        return Optional.empty();
    }

    public long getIslandLevel(@NotNull UUID uuid) {
        AtomicLong level = new AtomicLong(0L);
        this.findFirstIsland(uuid).ifPresent(island -> {
            try {
                level.addAndGet((Long)this.classLoader.findClass("world.bentobox.level.Level", false).getMethod("getIslandLevel", World.class, UUID.class).invoke((Object)this.classLoader.getAddon(), island.getWorld(), uuid));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        });
        return level.get();
    }

    public void removeIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        this.setIslandLevel(plugin, uuid, Math.max(0L, this.getIslandLevel(uuid) - level));
    }

    public void setIslandLevel(@NotNull Plugin plugin, @NotNull UUID uuid, long level) {
        this.findFirstIsland(uuid).ifPresent(island -> {
            try {
                if (!BentoBoxWrapper.isCache(plugin)) {
                    BentoBoxWrapper.setCache(plugin, true);
                    this.classLoader.findClass("world.bentobox.level.Level", false).getMethod("calculateIslandLevel", World.class, User.class, UUID.class).invoke((Object)this.classLoader.getAddon(), island.getWorld(), User.getInstance((UUID)uuid), uuid);
                }
                this.classLoader.findClass("world.bentobox.level.Level", false).getMethod("setIslandLevel", World.class, UUID.class, Long.TYPE).invoke((Object)this.classLoader.getAddon(), island.getWorld(), uuid, level);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public BentoBoxWrapper(@NotNull BentoBox bentoBox, @NotNull AddonClassLoader classLoader) {
        if (bentoBox == null) {
            throw new NullPointerException("bentoBox is marked non-null but is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.bentoBox = bentoBox;
        this.classLoader = classLoader;
    }
}

