/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtSlots
implements PlaceType {
    private final Collection<Integer> slots;

    @NotNull
    private static PtSlots create(@NotNull Map<String, Object> objects) {
        return new PtSlots(PlaceType.getIntegerList(objects, "slots", List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))));
    }

    @Override
    @NotNull
    public String getType() {
        return "slots";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        this.slots.forEach(slot -> contents.set((int)slot, icon));
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.addAsCollection("slots", this.slots, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public PtSlots(Collection<Integer> slots) {
        this.slots = slots;
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtSlots::create);
        }
    }
}

