/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element;

import com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.misc.Placeholder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFill;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillBorders;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillColumn;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillEmpties;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPattern;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPatternStart;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPatternStartIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRectFromTo;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRectIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPattern;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPatternStart;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPatternStartIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRow;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillSquareFromTo;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillSquareIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtInsert;
import tr.com.infumia.infumialib.platform.paper.element.types.PtInsertIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtNone;
import tr.com.infumia.infumialib.platform.paper.element.types.PtSlots;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.ClickEvent;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.SmartEvent;
import tr.com.infumia.infumialib.transformer.ObjectSerializer;
import tr.com.infumia.infumialib.transformer.TransformedData;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;

public final class FileElement {
    @NotNull
    private final List<Consumer<ClickEvent>> events;
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final PlaceType placeType;

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)PtFill.INSTANCE, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull Builder<?, ?> builder, Consumer<ClickEvent> ... events) {
        return FileElement.fill(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fill(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fill(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fill(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)PtFillBorders.INSTANCE, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull Builder<?, ?> builder, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillBorders(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fillBorders(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull ItemStack itemStack, int column, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillColumn(column), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull Builder<?, ?> builder, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(builder.getItemStack(), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull Material material, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(ItemStackBuilder.from(material), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillColumn(@NotNull XMaterial material, int column, Consumer<ClickEvent> ... events) {
        return FileElement.fillColumn(ItemStackBuilder.from(material), column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)PtFillEmpties.INSTANCE, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull Builder<?, ?> builder, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillEmpties(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.fillEmpties(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillPattern(wrapAround, pattern), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(builder.getItemStack(), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPattern(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillPatternStart(wrapAround, pattern, startRow, startColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(builder.getItemStack(), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStart(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillPatternStartIndex(wrapAround, pattern, startIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(builder.getItemStack(), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillPatternStartIndex(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, int startIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull ItemStack itemStack, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRectFromTo(fromRow, fromColumn, toRow, toColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull Builder<?, ?> builder, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(builder.getItemStack(), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull Material material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectFromTo(@NotNull XMaterial material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull ItemStack itemStack, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRectIndex(fromIndex, toIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull Builder<?, ?> builder, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(builder.getItemStack(), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull Material material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRectIndex(@NotNull XMaterial material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRectIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRepeatingPattern(wrapAround, pattern), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(builder.getItemStack(), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPattern(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPattern(ItemStackBuilder.from(material), wrapAround, pattern, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRepeatingPatternStart(wrapAround, pattern, startRow, startColumn, endRow, endColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(builder.getItemStack(), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStart(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, int startRow, int startColumn, int endRow, int endColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStart(ItemStackBuilder.from(material), wrapAround, pattern, startRow, startColumn, endRow, endColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull ItemStack itemStack, boolean wrapAround, @NotNull List<String> pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRepeatingPatternStartIndex(wrapAround, pattern, startIndex, endIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull Builder<?, ?> builder, boolean wrapAround, @NotNull List<String> pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(builder.getItemStack(), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull Material material, boolean wrapAround, @NotNull List<String> pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRepeatingPatternStartIndex(@NotNull XMaterial material, boolean wrapAround, @NotNull List<String> pattern, int startIndex, int endIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillRepeatingPatternStartIndex(ItemStackBuilder.from(material), wrapAround, pattern, startIndex, endIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull ItemStack itemStack, int row, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillRow(row), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull Builder<?, ?> builder, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(builder.getItemStack(), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull Material material, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(ItemStackBuilder.from(material), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillRow(@NotNull XMaterial material, int row, Consumer<ClickEvent> ... events) {
        return FileElement.fillRow(ItemStackBuilder.from(material), row, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull ItemStack itemStack, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillSquareFromTo(fromRow, fromColumn, toRow, toColumn), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull Builder<?, ?> builder, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(builder.getItemStack(), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull Material material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareFromTo(@NotNull XMaterial material, int fromRow, int fromColumn, int toRow, int toColumn, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareFromTo(ItemStackBuilder.from(material), fromRow, fromColumn, toRow, toColumn, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull ItemStack itemStack, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtFillSquareIndex(fromIndex, toIndex), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull Builder<?, ?> builder, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(builder.getItemStack(), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull Material material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement fillSquareIndex(@NotNull XMaterial material, int fromIndex, int toIndex, Consumer<ClickEvent> ... events) {
        return FileElement.fillSquareIndex(ItemStackBuilder.from(material), fromIndex, toIndex, events);
    }

    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, @NotNull List<Consumer<ClickEvent>> events) {
        return new FileElement(events, itemStack, placeType);
    }

    @SafeVarargs
    @NotNull
    public static FileElement from(@NotNull ItemStack itemStack, @NotNull PlaceType placeType, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, placeType, Arrays.asList(events));
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull ItemStack itemStack, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtInsert(row, column), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull Builder<?, ?> builder, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(builder.getItemStack(), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull Material material, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(ItemStackBuilder.from(material), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insert(@NotNull XMaterial material, int row, int column, Consumer<ClickEvent> ... events) {
        return FileElement.insert(ItemStackBuilder.from(material), row, column, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull ItemStack itemStack, int index, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtInsertIndex(index), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull Builder<?, ?> builder, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(builder.getItemStack(), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull Material material, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(ItemStackBuilder.from(material), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement insertIndex(@NotNull XMaterial material, int index, Consumer<ClickEvent> ... events) {
        return FileElement.insertIndex(ItemStackBuilder.from(material), index, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull ItemStack itemStack, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)PtNone.INSTANCE, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull Builder<?, ?> builder, Consumer<ClickEvent> ... events) {
        return FileElement.none(builder.getItemStack(), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull Material material, Consumer<ClickEvent> ... events) {
        return FileElement.none(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement none(@NotNull XMaterial material, Consumer<ClickEvent> ... events) {
        return FileElement.none(ItemStackBuilder.from(material), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull ItemStack itemStack, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.from(itemStack, (PlaceType)new PtSlots(slots), events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull Builder<?, ?> builder, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(builder.getItemStack(), slots, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull Material material, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(ItemStackBuilder.from(material), slots, events);
    }

    @SafeVarargs
    @NotNull
    public static FileElement slots(@NotNull XMaterial material, @NotNull List<Integer> slots, Consumer<ClickEvent> ... events) {
        return FileElement.slots(ItemStackBuilder.from(material), slots, events);
    }

    public FileElement addEvent(@NotNull Consumer<ClickEvent> event) {
        ArrayList<Consumer<ClickEvent>> events = new ArrayList<Consumer<ClickEvent>>(this.getEvents());
        events.add(event);
        return this.changeEvent(events);
    }

    @NotNull
    public FileElement changeEvent(@NotNull List<Consumer<ClickEvent>> events) {
        return this.duplicate(events);
    }

    @NotNull
    public FileElement changeItemStack(@NotNull ItemStack itemStack) {
        return this.duplicate(itemStack);
    }

    @NotNull
    public FileElement changeLore(boolean colored, @NotNull List<String> lore) {
        return this.changeItemStack(((ItemStackBuilder)ItemStackBuilder.from(this.getItemStack()).setLore(lore, colored)).getItemStack());
    }

    @NotNull
    public FileElement changeLore(boolean colored, String ... lore) {
        return this.changeLore(colored, Arrays.asList(lore));
    }

    @NotNull
    public FileElement changeLore(@NotNull List<String> lore) {
        return this.changeLore(true, lore);
    }

    @NotNull
    public FileElement changeLore(String ... lore) {
        return this.changeLore(true, lore);
    }

    @NotNull
    public FileElement changeMaterial(@NotNull Material material) {
        ItemStack clone = this.getItemStack();
        clone.setType(material);
        return this.changeItemStack(clone);
    }

    @NotNull
    public FileElement changeMaterial(@NotNull XMaterial xmaterial) {
        ItemStack clone = this.getItemStack();
        Optional.ofNullable(xmaterial.parseMaterial()).ifPresent(arg_0 -> ((ItemStack)clone).setType(arg_0));
        return this.changeItemStack(clone);
    }

    @NotNull
    public FileElement changeName(boolean colored, @NotNull String name) {
        return this.changeItemStack(((ItemStackBuilder)ItemStackBuilder.from(this.getItemStack()).setName(name, colored)).getItemStack());
    }

    @NotNull
    public FileElement changeName(@NotNull String name) {
        return this.changeName(true, name);
    }

    @NotNull
    public FileElement changeType(@NotNull PlaceType type) {
        return this.duplicate(type);
    }

    @NotNull
    public Icon clickableItem() {
        Icon icon = Icon.from(this.getItemStack());
        this.getEvents().forEach(icon::whenClick);
        return icon;
    }

    @NotNull
    public List<Consumer<ClickEvent>> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public void place(@NotNull InventoryContents contents) {
        this.placeType.place(this.clickableItem(), contents);
    }

    public void place(@NotNull SmartEvent event) {
        this.place(event.contents());
    }

    @NotNull
    public FileElement replace(@NotNull String regex, @NotNull Object replace) {
        return this.replace(true, true, regex, replace);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, @NotNull String regex, @NotNull Object replace) {
        return this.replace(name, lore, Placeholder.from(regex, replace));
    }

    @NotNull
    public FileElement replace(Placeholder ... placeholders) {
        return this.replace(true, true, placeholders);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, Placeholder ... placeholders) {
        return this.replace(name, lore, Arrays.asList(placeholders));
    }

    @NotNull
    public FileElement replace(@NotNull Iterable<Placeholder> placeholders) {
        return this.replace(true, true, placeholders);
    }

    @NotNull
    public FileElement replace(boolean name, boolean lore, @NotNull Iterable<Placeholder> placeholders) {
        ItemStack clone = this.getItemStack();
        Optional.ofNullable(clone.getItemMeta()).ifPresent(itemMeta -> {
            if (name && itemMeta.hasDisplayName()) {
                placeholders.forEach(placeholder -> itemMeta.setDisplayName(placeholder.replace(itemMeta.getDisplayName())));
            }
            if (lore && itemMeta.getLore() != null && itemMeta.hasLore()) {
                ArrayList finallore = new ArrayList();
                itemMeta.getLore().forEach(s -> {
                    AtomicReference<String> finalstring = new AtomicReference<String>((String)s);
                    placeholders.forEach(placeholder -> finalstring.set(placeholder.replace((String)finalstring.get())));
                    finallore.add(finalstring.get());
                });
                itemMeta.setLore(finallore);
            }
            clone.setItemMeta(itemMeta);
        });
        return this.changeItemStack(clone);
    }

    public void set(@NotNull InventoryContents contents, int row, int column) {
        contents.set(row, column, this.clickableItem());
    }

    @NotNull
    private FileElement duplicate(@NotNull ItemStack itemStack) {
        return FileElement.from(itemStack, this.placeType, this.getEvents());
    }

    @NotNull
    private FileElement duplicate(@NotNull PlaceType type) {
        return FileElement.from(this.getItemStack(), type, this.getEvents());
    }

    @NotNull
    private FileElement duplicate(@NotNull List<Consumer<ClickEvent>> events) {
        return FileElement.from(this.getItemStack(), this.placeType, events);
    }

    public FileElement(@NotNull List<Consumer<ClickEvent>> events, @NotNull ItemStack itemStack, @NotNull PlaceType placeType) {
        if (events == null) {
            throw new NullPointerException("events is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (placeType == null) {
            throw new NullPointerException("placeType is marked non-null but is null");
        }
        this.events = events;
        this.itemStack = itemStack;
        this.placeType = placeType;
    }

    @NotNull
    public PlaceType getPlaceType() {
        return this.placeType;
    }

    public static final class Serializer
    implements ObjectSerializer<FileElement> {
        @Override
        @NotNull
        public Optional<FileElement> deserialize(@NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<FileElement> deserialize(@NotNull FileElement fileElement, @NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            Optional<ItemStack> itemStack = transformedData.get("item", ItemStack.class);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            Optional<String> type = transformedData.get("type", String.class);
            if (type.isEmpty()) {
                return Optional.empty();
            }
            Optional<PlaceType.Deserializer> deserializer = PlaceType.getByType(type.get());
            if (deserializer.isEmpty()) {
                return Optional.empty();
            }
            Optional<PlaceType> placeType = deserializer.get().deserialize(transformedData);
            if (placeType.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(FileElement.from(itemStack.get(), placeType.get(), new Consumer[0]).changeEvent(fileElement.getEvents()));
        }

        @Override
        public void serialize(@NotNull FileElement fileElement, @NotNull TransformedData transformedData) {
            transformedData.add("item", fileElement.getItemStack(), ItemStack.class);
            fileElement.getPlaceType().serialize(transformedData);
        }

        @Override
        public boolean supports(@NotNull Class<?> cls) {
            return cls == FileElement.class;
        }
    }
}

