/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.XItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;

public final class FireworkItemBuilder
extends Builder<FireworkItemBuilder, FireworkMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    FireworkItemBuilder(@NotNull FireworkMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static FireworkItemBuilder from(@NotNull FireworkMeta itemMeta, @NotNull ItemStack itemStack) {
        return new FireworkItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static FireworkItemBuilder from(@NotNull TransformedData data) {
        return FireworkItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @NotNull
    public FireworkItemBuilder addEffect(@NotNull FireworkEffect effect) {
        ((FireworkMeta)this.getItemMeta()).addEffect(effect);
        return this.getSelf();
    }

    @NotNull
    public FireworkItemBuilder addEffects(FireworkEffect ... effects) {
        ((FireworkMeta)this.getItemMeta()).addEffects(effects);
        return this.getSelf();
    }

    @NotNull
    public FireworkItemBuilder addEffects(@NotNull Iterable<FireworkEffect> effects) {
        ((FireworkMeta)this.getItemMeta()).addEffects(effects);
        return this.getSelf();
    }

    @NotNull
    public FireworkItemBuilder clearEffects() {
        ((FireworkMeta)this.getItemMeta()).clearEffects();
        return this.getSelf();
    }

    @Override
    @NotNull
    public FireworkItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        FireworkMeta itemMeta = (FireworkMeta)this.getItemMeta();
        TransformedData copy = data.copy();
        data.add("power", itemMeta.getPower(), Integer.TYPE);
        List effects = itemMeta.getEffects();
        int bound = effects.size();
        for (int index = 0; index < bound; ++index) {
            FireworkEffect effect = (FireworkEffect)effects.get(index);
            TransformedData copyCopy = copy.copy();
            copyCopy.add("type", effect.getType().name(), String.class);
            copyCopy.add("flicker", effect.hasFlicker(), Boolean.TYPE);
            copyCopy.add("trail", effect.hasTrail(), Boolean.TYPE);
            List fwBaseColors = effect.getColors();
            List fwFadeColors = effect.getFadeColors();
            TransformedData copyCopyCopy = copyCopy.copy();
            ArrayList<String> baseColors = new ArrayList<String>(fwBaseColors.size());
            for (Color fwBaseColor : fwBaseColors) {
                baseColors.add(String.format("%d, %d, %d", fwBaseColor.getRed(), fwBaseColor.getGreen(), fwBaseColor.getBlue()));
            }
            ArrayList<String> fadeColors = new ArrayList<String>(fwFadeColors.size());
            for (Color color : fwFadeColors) {
                fadeColors.add(String.format("%d, %d, %d", color.getRed(), color.getGreen(), color.getBlue()));
            }
            copyCopyCopy.addAsCollection("base", baseColors, String.class);
            copyCopyCopy.addAsCollection("fade", fadeColors, String.class);
            copyCopy.add("colors", copyCopyCopy);
            copy.add(String.valueOf(index), copyCopy);
        }
        data.add("firework", copy);
    }

    @NotNull
    public FireworkItemBuilder removeEffect(int effectId) {
        ((FireworkMeta)this.getItemMeta()).removeEffect(effectId);
        return this.getSelf();
    }

    @NotNull
    public FireworkItemBuilder setPower(int power) {
        ((FireworkMeta)this.getItemMeta()).setPower(power);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<FireworkItemBuilder>> {
        @Override
        @NotNull
        public Optional<FireworkItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            FireworkItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asFirework();
            Integer power = data.get("power", Integer.TYPE).orElse(1);
            builder.setPower(power);
            Optional fireworkSection = data.getAsMap("firework", GenericDeclaration.of(String.class), GenericDeclaration.of(Map.class, String.class, Object.class));
            fireworkSection.ifPresent(firework -> {
                FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
                firework.forEach((key, value) -> {
                    FireworkEffect.Type effectType;
                    TransformedData copy = data.copy((Map<String, Object>)value);
                    Boolean flicker = copy.get("flicker", Boolean.TYPE).orElse(false);
                    Boolean trail = copy.get("trail", Boolean.TYPE).orElse(false);
                    Optional<String> type = copy.get("type", String.class).map(s -> s.toUpperCase(Locale.ROOT));
                    try {
                        effectType = type.map(FireworkEffect.Type::valueOf).orElse(FireworkEffect.Type.STAR);
                    }
                    catch (Exception e) {
                        effectType = FireworkEffect.Type.STAR;
                    }
                    fireworkBuilder.flicker(flicker.booleanValue()).trail(trail.booleanValue()).with(effectType);
                    copy.getAsMap("colors", String.class, Object.class).ifPresent(colorSection -> {
                        TransformedData copyCopy = copy.copy((Map<String, Object>)colorSection);
                        Set baseColors = copyCopy.getAsCollection("base", String.class).map(strings -> {
                            HashSet<Color> set = new HashSet<Color>();
                            for (String string : strings) {
                                set.add(XItemStack.parseColor((String)string));
                            }
                            return set;
                        }).orElse(Collections.emptySet());
                        Set fadeColors = copyCopy.getAsCollection("fade", String.class).map(strings -> {
                            HashSet<Color> set = new HashSet<Color>();
                            for (String string : strings) {
                                set.add(XItemStack.parseColor((String)string));
                            }
                            return set;
                        }).orElse(Collections.emptySet());
                        fireworkBuilder.withColor(baseColors).withFade(fadeColors);
                    });
                    builder.addEffect(fireworkBuilder.build());
                });
            });
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

