/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class BannerItemBuilder
extends Builder<BannerItemBuilder, BannerMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    BannerItemBuilder(@NotNull BannerMeta meta, @NotNull ItemStack itemStack) {
        super(meta, itemStack);
    }

    @NotNull
    public static BannerItemBuilder from(@NotNull BannerMeta itemMeta, @NotNull ItemStack itemStack) {
        return new BannerItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static BannerItemBuilder from(@NotNull TransformedData data) {
        return BannerItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @NotNull
    public BannerItemBuilder addPatterns(Pattern ... patterns) {
        BannerMeta bannerMeta = (BannerMeta)this.getItemMeta();
        for (Pattern pattern : patterns) {
            bannerMeta.addPattern(pattern);
        }
        return this.getSelf();
    }

    @Override
    @NotNull
    public BannerItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        HashMap patterns = new HashMap();
        ((BannerMeta)this.getItemMeta()).getPatterns().forEach(pattern -> patterns.put(pattern.getPattern().name(), pattern.getColor().name()));
        data.addAsMap("patterns", patterns, String.class, String.class);
    }

    @NotNull
    public BannerItemBuilder removePatterns(int ... index) {
        BannerMeta bannerMeta = (BannerMeta)this.getItemMeta();
        for (int i : index) {
            bannerMeta.removePattern(i);
        }
        return this.getSelf();
    }

    @Deprecated
    @NotNull
    public BannerItemBuilder setBaseColor(@NotNull DyeColor color) {
        ((BannerMeta)this.getItemMeta()).setBaseColor(color);
        return this.getSelf();
    }

    @NotNull
    public BannerItemBuilder setPattern(int index, @NotNull Pattern pattern) {
        ((BannerMeta)this.getItemMeta()).setPattern(index, pattern);
        return this.getSelf();
    }

    @NotNull
    public BannerItemBuilder setPatterns(Pattern ... patterns) {
        return this.setPatterns(List.of(patterns));
    }

    @NotNull
    public BannerItemBuilder setPatterns(@NotNull List<Pattern> patterns) {
        ((BannerMeta)this.getItemMeta()).setPatterns(patterns);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<BannerItemBuilder>> {
        @Override
        @NotNull
        public Optional<BannerItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            BannerItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asBanner();
            data.getAsMap("patterns", String.class, String.class).ifPresent(patterns -> patterns.forEach((key, value) -> {
                DyeColor color;
                PatternType type = PatternType.getByIdentifier((String)key);
                if (type == null) {
                    try {
                        type = PatternType.valueOf((String)key.toUpperCase(Locale.ENGLISH));
                    }
                    catch (Exception e) {
                        type = PatternType.BASE;
                    }
                }
                try {
                    color = DyeColor.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                }
                catch (Exception e) {
                    color = DyeColor.WHITE;
                }
                builder.addPatterns(new Pattern(color, type));
            }));
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

