/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.http;

import com.google.protobuf.GeneratedMessageV3;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.http.Clients;
import tr.com.infumia.infumialib.misc.UncheckedOptionalSupplier;

public final class Http {
    public static boolean delete(@NotNull URI url) {
        return Http.delete(Clients.DEFAULT_CLIENT, url);
    }

    public static boolean delete(@NotNull HttpClient client, @NotNull URI url) {
        return Http.succeedRequest(client, Http.buildDelete(url));
    }

    @NotNull
    public static Optional<String> getString(@NotNull URI url) {
        return Http.getString(Clients.DEFAULT_CLIENT, url);
    }

    @NotNull
    public static Optional<String> getString(@NotNull HttpClient client, @NotNull URI url) {
        return Http.requestBody(client, Http.buildGet(url), HttpResponse.BodyHandlers.ofString());
    }

    @NotNull
    public static <T extends GeneratedMessageV3> Optional<T> protoGet(@NotNull URI url, @NotNull T template) {
        return Http.protoGet(Clients.DEFAULT_CLIENT, url, template);
    }

    @NotNull
    public static <T extends GeneratedMessageV3> Optional<T> protoGet(@NotNull HttpClient client, @NotNull URI url, @NotNull T template) {
        return Http.protoConvert(client, Http.buildGet(url), template);
    }

    @NotNull
    public static <T extends GeneratedMessageV3, B extends GeneratedMessageV3> Optional<T> protoPost(@NotNull URI url, @NotNull T template, @NotNull B body) {
        return Http.protoPost(Clients.DEFAULT_CLIENT, url, template, body);
    }

    @NotNull
    public static <T extends GeneratedMessageV3, B extends GeneratedMessageV3> Optional<T> protoPost(@NotNull HttpClient client, @NotNull URI url, @NotNull T template, @NotNull B body) {
        return Http.protoConvert(client, Http.buildPost(url, HttpRequest.BodyPublishers.ofByteArray(body.toByteArray())), template);
    }

    public static <T extends GeneratedMessageV3> boolean protoPost(@NotNull URI url, @NotNull T body) {
        return Http.protoPost(Clients.DEFAULT_CLIENT, url, body);
    }

    public static <T extends GeneratedMessageV3> boolean protoPost(@NotNull HttpClient client, @NotNull URI url, @NotNull T body) {
        return Http.succeedRequest(client, Http.buildPost(url, HttpRequest.BodyPublishers.ofByteArray(body.toByteArray())), HttpResponse.BodyHandlers.ofInputStream());
    }

    @NotNull
    private static HttpRequest buildDelete(@NotNull URI url) {
        return HttpRequest.newBuilder().DELETE().uri(url).build();
    }

    @NotNull
    private static HttpRequest buildGet(@NotNull URI url) {
        return HttpRequest.newBuilder().GET().uri(url).build();
    }

    @NotNull
    private static HttpRequest buildPost(@NotNull URI url, @NotNull HttpRequest.BodyPublisher bodyPublisher) {
        return HttpRequest.newBuilder().POST(bodyPublisher).uri(url).build();
    }

    @NotNull
    private static <T extends GeneratedMessageV3> Optional<T> protoConvert(@NotNull HttpClient client, @NotNull HttpRequest request, @NotNull T template) {
        return Http.request(client, request, HttpResponse.BodyHandlers.ofInputStream()).filter(response -> response.statusCode() == 200).map(response -> () -> (GeneratedMessageV3)template.getParserForType().parseFrom((InputStream)response.body())).map(UncheckedOptionalSupplier::new).flatMap(Supplier::get);
    }

    @NotNull
    private static <T> Optional<HttpResponse<T>> request(@NotNull HttpClient client, @NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<T> bodyHandler) {
        return new UncheckedOptionalSupplier(() -> client.send(request, bodyHandler)).get();
    }

    @NotNull
    private static <T> Optional<T> requestBody(@NotNull HttpClient client, @NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<T> bodyHandler) {
        return Http.request(client, request, bodyHandler).filter(response -> response.statusCode() == 200).map(HttpResponse::body);
    }

    private static boolean succeedRequest(@NotNull HttpClient client, @NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<?> bodyHandler) {
        return Http.request(client, request, bodyHandler).map(HttpResponse::statusCode).map(integer -> integer == 200).orElse(false);
    }

    private static boolean succeedRequest(@NotNull HttpClient client, @NotNull HttpRequest request) {
        return Http.succeedRequest(client, request, HttpResponse.BodyHandlers.ofString());
    }

    private Http() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

