/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.dynamism;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.dynamism.Dynamic;

public final class DynamicRegistry {
    private final Map<Class<? extends Dynamic>, String> dynamicsByClass = new ConcurrentHashMap<Class<? extends Dynamic>, String>();
    private final Map<String, Class<? extends Dynamic>> dynamicsByKey = new ConcurrentHashMap<String, Class<? extends Dynamic>>();

    @NotNull
    public Dynamic create(@NotNull String key) {
        return this.create(Objects.requireNonNull(this.get(key), "Key %s not found!".formatted(key)));
    }

    @NotNull
    public <T extends Dynamic> T create(@NotNull Class<T> cls) {
        if (!this.dynamicsByClass.containsKey(cls)) {
            throw new IllegalStateException("The dynamic class '%s' not found!");
        }
        try {
            return (T)((Dynamic)cls.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Default constructor not found!", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The constructor is inaccessible!", e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Something went wrong when creating the dynamic!", e);
        }
    }

    @Nullable
    public Class<? extends Dynamic> get(@NotNull String key) {
        return this.dynamicsByKey.get(key);
    }

    public void register(@NotNull String key, @NotNull Class<? extends Dynamic> cls) {
        this.dynamicsByKey.put(key, cls);
        this.dynamicsByClass.put(cls, key);
    }
}

