/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class Placeholder {
    @NotNull
    private final Pattern regex;
    @NotNull
    private final Supplier<Object> replace;

    @NotNull
    public static Placeholder from(@NotNull Pattern regex, @NotNull Supplier<Object> replace) {
        return new Placeholder(regex, replace);
    }

    @NotNull
    public static Placeholder from(@NotNull String regex, @NotNull Supplier<Object> replace) {
        return Placeholder.from(Pattern.compile(regex), replace);
    }

    @NotNull
    public static Placeholder from(@NotNull Pattern regex, @NotNull Object replace) {
        return Placeholder.from(regex, () -> replace);
    }

    @NotNull
    public static Placeholder from(@NotNull String regex, @NotNull Object replace) {
        return Placeholder.from(Pattern.compile(regex), replace);
    }

    @NotNull
    public String replace(@NotNull String text) {
        return this.regex.matcher(text).replaceAll(this.replace());
    }

    @NotNull
    public Collection<String> replace(@NotNull Collection<String> texts) {
        return this.replace(texts, ArrayList::new);
    }

    @NotNull
    public Collection<String> replace(@NotNull Collection<String> texts, @NotNull Supplier<? extends Collection<String>> collectionSupplier) {
        return texts.stream().map(s -> this.regex.matcher((CharSequence)s).replaceAll(this.replace())).collect(Collectors.toCollection(collectionSupplier));
    }

    @NotNull
    private String replace() {
        return String.valueOf(this.replace.get());
    }

    private Placeholder(@NotNull Pattern regex, @NotNull Supplier<Object> replace) {
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        if (replace == null) {
            throw new NullPointerException("replace is marked non-null but is null");
        }
        this.regex = regex;
        this.replace = replace;
    }
}

