/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.libby.relocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Relocation(@NotNull String pattern, @NotNull String relocatedPattern, @Nullable Collection<String> includes, @Nullable Collection<String> excludes) {
    public Relocation(@NotNull String pattern, @NotNull String relocatedPattern, @Nullable Collection<String> includes, @Nullable Collection<String> excludes) {
        pattern = pattern.replace("{}", ".");
        relocatedPattern = relocatedPattern.replace("{}", ".");
    }

    public Relocation(@NotNull String pattern, @NotNull String relocatedPattern) {
        this(pattern, relocatedPattern, null, null);
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Collection<String> excludes;
        @Nullable
        private Collection<String> includes;
        @Nullable
        private String pattern;
        @Nullable
        private String relocatedPattern;

        @NotNull
        public Relocation build() {
            String relocatedPattern = Objects.requireNonNull(this.relocatedPattern);
            String pattern = Objects.requireNonNull(this.pattern);
            return new Relocation(pattern, relocatedPattern, this.includes, this.excludes);
        }

        @NotNull
        public Builder exclude(@NotNull String exclude) {
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            this.excludes.add(exclude);
            return this;
        }

        @NotNull
        public Builder include(@NotNull String include) {
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            this.includes.add(include);
            return this;
        }

        public Builder pattern(@Nullable String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder relocatedPattern(@Nullable String relocatedPattern) {
            this.relocatedPattern = relocatedPattern;
            return this;
        }
    }
}

