/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.libby;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.libby.relocation.Relocation;

public record Library(@Nullable Collection<String> urls, @Nullable Collection<String> repositories, @NotNull String id, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @NotNull String path, byte @Nullable [] checksum, @Nullable Collection<Relocation> relocations, @Nullable String relocatedPath, boolean isolatedLoad) {
    public Library(@Nullable Collection<String> urls, @Nullable Collection<String> repositories, @NotNull String id, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @NotNull String path, byte[] checksum, @Nullable Collection<Relocation> relocations, @Nullable String relocatedPath, boolean isolatedLoad) {
        groupId = groupId.replace("{}", ".");
        path = groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version;
        if (classifier != null) {
            path = (String)path + "-" + classifier;
        }
        path = (String)path + ".jar";
        relocatedPath = relocations != null && !relocations.isEmpty() ? (String)path + "-relocated.jar" : null;
    }

    public Library(@Nullable Collection<String> urls, @Nullable Collection<String> repositories, @NotNull String id, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, byte @Nullable [] checksum, @Nullable Collection<Relocation> relocations, boolean isolatedLoad) {
        this(urls, repositories, id, groupId, artifactId, version, classifier, "", checksum, relocations, null, isolatedLoad);
    }

    public Library(@Nullable Collection<String> urls, @NotNull String id, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, byte @Nullable [] checksum, @Nullable Collection<Relocation> relocations, boolean isolatedLoad) {
        this(urls, null, id, groupId, artifactId, version, classifier, checksum, relocations, isolatedLoad);
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean hasChecksum() {
        return this.checksum != null;
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public boolean hasRelocations() {
        return this.relocations != null && !this.relocations.isEmpty();
    }

    @Override
    @NotNull
    public String toString() {
        String name = this.groupId + ":" + this.artifactId + ":" + this.version;
        if (this.classifier != null) {
            name = name + ":" + this.classifier;
        }
        return name;
    }

    public static final class Builder {
        @Nullable
        private String artifactId;
        private byte @Nullable [] checksum;
        @Nullable
        private String classifier;
        @Nullable
        private String groupId;
        @Nullable
        private String id;
        private boolean isolatedLoad;
        @Nullable
        private Collection<Relocation> relocations;
        @Nullable
        private Collection<String> repositories;
        @Nullable
        private Collection<String> urls;
        @Nullable
        private String version;

        @NotNull
        public Library build() {
            String id = Objects.requireNonNull(this.id);
            String groupId = Objects.requireNonNull(this.groupId);
            String artifactId = Objects.requireNonNull(this.artifactId);
            String version = Objects.requireNonNull(this.version);
            return new Library(this.urls, this.repositories, id, groupId, artifactId, version, this.classifier, this.checksum, this.relocations, this.isolatedLoad);
        }

        @NotNull
        public Builder checksumText(@NotNull String checksum) {
            return this.checksum(Base64.getDecoder().decode(checksum));
        }

        @NotNull
        public Builder relocate(@NotNull Relocation relocation) {
            if (this.relocations == null) {
                this.relocations = new ArrayList<Relocation>();
            }
            this.relocations.add(relocation);
            return this;
        }

        @NotNull
        public Builder relocate(@NotNull String pattern, @NotNull String relocatedPattern) {
            return this.relocate(new Relocation(pattern, relocatedPattern));
        }

        @NotNull
        public Builder repository(@NotNull String url) {
            if (this.repositories == null) {
                this.repositories = new ArrayList<String>();
            }
            this.repositories.add((String)(url.endsWith("/") ? url : url + "/"));
            return this;
        }

        @NotNull
        public Builder url(@NotNull String url) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            this.urls.add(url);
            return this;
        }

        private Builder() {
        }

        public Builder artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder checksum(byte @Nullable [] checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public Builder isolatedLoad(boolean isolatedLoad) {
            this.isolatedLoad = isolatedLoad;
            return this;
        }

        public Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }
    }
}

