/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.math;

import tr.com.infumia.infumialib.math.EvaluationException;
import tr.com.infumia.infumialib.math.ExpressionNode;

public class VariableNode
implements ExpressionNode {
    protected ExpressionNode[] children = new ExpressionNode[0];
    protected boolean error;
    protected String name;
    protected double value;

    public VariableNode(String name, boolean error) {
        this.name = name;
        this.value = 0.0;
        this.error = error;
    }

    @Override
    public Object clone() {
        VariableNode node = new VariableNode(this.name, this.error);
        node.value = this.value;
        return node;
    }

    @Override
    public String toString() {
        return this.getSubtype();
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public String getSubtype() {
        return this.name;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public double getValue() {
        if (!this.error) {
            return this.value;
        }
        throw new EvaluationException("Variable '" + this.name + "' was not initialized.");
    }

    @Override
    public void setVariable(String name, double value) {
        if (this.name.equals(name)) {
            this.value = value;
            this.error = false;
        }
    }
}

