/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.proto;

import io.grpc.stub.StreamObserver;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class FunctionalObserver<V>
implements StreamObserver<V> {
    @NotNull
    private final Runnable onCompleted;
    @NotNull
    private final Consumer<Throwable> onError;
    @NotNull
    private final Consumer<V> onNext;

    public FunctionalObserver(@NotNull Runnable onCompleted, @NotNull Consumer<Throwable> onError) {
        this(onCompleted, onError, v -> {});
    }

    public void onNext(V value) {
        this.onNext.accept(value);
    }

    public void onError(Throwable t) {
        this.onError.accept(t);
    }

    public void onCompleted() {
        this.onCompleted.run();
    }

    public FunctionalObserver(@NotNull Runnable onCompleted, @NotNull Consumer<Throwable> onError, @NotNull Consumer<V> onNext) {
        if (onCompleted == null) {
            throw new NullPointerException("onCompleted is marked non-null but is null");
        }
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        if (onNext == null) {
            throw new NullPointerException("onNext is marked non-null but is null");
        }
        this.onCompleted = onCompleted;
        this.onError = onError;
        this.onNext = onNext;
    }
}

