/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;

public final class FireworkItemBuilder
extends ItemStackBuilder<FireworkMeta, FireworkItemBuilder> {
    private FireworkItemBuilder(@NotNull FireworkMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static FireworkItemBuilder from(@NotNull FireworkMeta itemMeta, @NotNull ItemStack itemStack) {
        return new FireworkItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public FireworkItemBuilder addEffect(@NotNull FireworkEffect effect) {
        ((FireworkMeta)this.itemMeta()).addEffect(effect);
        return this.self();
    }

    @NotNull
    public FireworkItemBuilder addEffects(FireworkEffect ... effects) {
        ((FireworkMeta)this.itemMeta()).addEffects(effects);
        return this.self();
    }

    @NotNull
    public FireworkItemBuilder addEffects(@NotNull Iterable<FireworkEffect> effects) {
        ((FireworkMeta)this.itemMeta()).addEffects(effects);
        return this.self();
    }

    @NotNull
    public FireworkItemBuilder clearEffects() {
        ((FireworkMeta)this.itemMeta()).clearEffects();
        return this.self();
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        int power = node.node(new Object[]{"power"}).getInt(1);
        this.power(power);
        for (Map.Entry entry : node.node(new Object[]{"firework"}).childrenMap().entrySet()) {
            FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
            for (Map.Entry inner : ((ConfigurationNode)entry.getValue()).childrenMap().entrySet()) {
                FireworkEffect.Type effectType;
                ConfigurationNode innerNode = (ConfigurationNode)inner.getValue();
                boolean flicker = innerNode.node(new Object[]{"flicker"}).getBoolean();
                boolean trail = innerNode.node(new Object[]{"trail"}).getBoolean();
                Optional<String> type = Optional.ofNullable(innerNode.node(new Object[]{"type"}).getString()).map(s -> s.toUpperCase(Locale.ROOT));
                try {
                    effectType = type.map(FireworkEffect.Type::valueOf).orElse(FireworkEffect.Type.STAR);
                }
                catch (Exception e) {
                    effectType = FireworkEffect.Type.STAR;
                }
                fireworkBuilder.flicker(flicker).trail(trail).with(effectType);
                for (Map.Entry colorEntry : innerNode.node(new Object[]{"colors"}).childrenMap().entrySet()) {
                    ConfigurationNode colorNode = (ConfigurationNode)colorEntry.getValue();
                    List baseColors = colorNode.node(new Object[]{"base"}).getList(Color.class, Collections.emptyList());
                    List fadeColors = colorNode.node(new Object[]{"fade"}).getList(Color.class, Collections.emptyList());
                    fireworkBuilder.withColor((Iterable)baseColors).withFade((Iterable)fadeColors);
                }
                this.addEffect(fireworkBuilder.build());
            }
        }
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        FireworkMeta itemMeta = (FireworkMeta)this.itemMeta();
        List effects = itemMeta.getEffects();
        int bound = effects.size();
        node.node(new Object[]{"power"}).getInt();
        ConfigurationNode fireworkNode = node.node(new Object[]{"firework"});
        for (int index = 0; index < bound; ++index) {
            ConfigurationNode innerNode = fireworkNode.node(new Object[]{String.valueOf(index)});
            FireworkEffect effect = (FireworkEffect)effects.get(index);
            List baseColors = effect.getColors();
            List fadeColors = effect.getFadeColors();
            innerNode.node(new Object[]{"type"}).set((Object)effect.getType().name());
            innerNode.node(new Object[]{"flicker"}).set((Object)effect.hasFlicker());
            innerNode.node(new Object[]{"trail"}).set((Object)effect.hasTrail());
            ConfigurationNode colorsNode = innerNode.node(new Object[]{"colors"});
            colorsNode.node(new Object[]{"base"}).setList(Color.class, baseColors);
            colorsNode.node(new Object[]{"fade"}).setList(Color.class, fadeColors);
        }
    }

    @NotNull
    public FireworkItemBuilder power(int power) {
        ((FireworkMeta)this.itemMeta()).setPower(power);
        return this.self();
    }

    @NotNull
    public FireworkItemBuilder removeEffect(int effectId) {
        ((FireworkMeta)this.itemMeta()).removeEffect(effectId);
        return this.self();
    }

    @NotNull
    public FireworkItemBuilder self() {
        return this;
    }
}

