/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.listener;

import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public abstract class ListenerHandler<E extends Event>
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final PluginManager pluginManager;

    protected ListenerHandler(@NotNull Plugin plugin) {
        this(plugin, plugin.getServer().getPluginManager());
    }

    public final void register() {
        this.pluginManager.registerEvents((Listener)this, this.plugin);
    }

    public final void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    public abstract void handle(@NotNull E var1);

    private ListenerHandler(@NotNull Plugin plugin, @NotNull PluginManager pluginManager) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (pluginManager == null) {
            throw new NullPointerException("pluginManager is marked non-null but is null");
        }
        this.plugin = plugin;
        this.pluginManager = pluginManager;
    }

    @NotNull
    protected Plugin getPlugin() {
        return this.plugin;
    }
}

