/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.worldborderapi;

import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.EarthBorder;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.Position;

public final class BorderData {
    private double damageAmount;
    private double damageBufferInBlocks;
    private double size;
    private int warningDistance;
    private int warningTimeSeconds;
    private double x;
    private double z;

    public void applyAll(@NotNull EarthBorder border) {
        border.size(this.size);
        border.center(new Position(this.x, this.z));
        border.damageBufferInBlocks(this.damageBufferInBlocks);
        border.warningTimeInSeconds(this.warningTimeSeconds);
        border.damagePerSecondPerBlock(this.damageAmount);
        border.warningDistanceInBlocks(this.warningDistance);
    }

    public void applyCenter(@NotNull BiConsumer<Double, Double> consumer) {
        consumer.accept(this.x, this.z);
    }

    public void center(double x, double z) {
        this.x(x).z(z);
    }

    public BorderData damageAmount(double damageAmount) {
        this.damageAmount = damageAmount;
        return this;
    }

    public BorderData damageBufferInBlocks(double damageBufferInBlocks) {
        this.damageBufferInBlocks = damageBufferInBlocks;
        return this;
    }

    public BorderData size(double size) {
        this.size = size;
        return this;
    }

    public BorderData warningDistance(int warningDistance) {
        this.warningDistance = warningDistance;
        return this;
    }

    public BorderData warningTimeSeconds(int warningTimeSeconds) {
        this.warningTimeSeconds = warningTimeSeconds;
        return this;
    }

    public BorderData x(double x) {
        this.x = x;
        return this;
    }

    public BorderData z(double z) {
        this.z = z;
        return this;
    }

    public double damageAmount() {
        return this.damageAmount;
    }

    public double damageBufferInBlocks() {
        return this.damageBufferInBlocks;
    }

    public double size() {
        return this.size;
    }

    public int warningDistance() {
        return this.warningDistance;
    }

    public int warningTimeSeconds() {
        return this.warningTimeSeconds;
    }

    public double x() {
        return this.x;
    }

    public double z() {
        return this.z;
    }
}

